/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.core.Monitor;
import org.simpleframework.http.core.Producer;
import org.simpleframework.http.core.ProducerException;
import org.simpleframework.http.core.Sender;

class FixedProducer
implements Producer {
    private Monitor monitor;
    private Sender sender;
    private int count;
    private int limit;

    public FixedProducer(Sender sender, Monitor monitor, int limit) {
        this.monitor = monitor;
        this.sender = sender;
        this.limit = limit;
    }

    public void produce(byte[] array) throws IOException {
        this.produce(array, 0, array.length);
    }

    public void produce(byte[] array, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array, off, len);
        if (len > 0) {
            this.produce(buffer);
        }
    }

    public void produce(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new ProducerException("Buffer position greater than limit");
        }
        this.produce(buffer, 0, size - mark);
    }

    public void produce(ByteBuffer buffer, int off, int len) throws IOException {
        int size = Math.min(len, this.limit - this.count);
        try {
            if (this.monitor.isClosed()) {
                throw new ProducerException("Response content complete");
            }
            this.sender.send(buffer, off, size);
            if (this.count + size == this.limit) {
                this.monitor.ready(this.sender);
            }
        }
        catch (Exception cause) {
            if (this.sender != null) {
                this.monitor.error(this.sender);
            }
            throw new ProducerException("Error sending response", cause);
        }
        this.count += size;
    }

    public void flush() throws IOException {
        try {
            if (!this.monitor.isClosed()) {
                this.sender.flush();
            }
        }
        catch (Exception cause) {
            if (this.sender != null) {
                this.monitor.error(this.sender);
            }
            throw new ProducerException("Error flushing", cause);
        }
    }

    public void close() throws IOException {
        if (!this.monitor.isClosed()) {
            if (this.count < this.limit) {
                this.monitor.error(this.sender);
            } else {
                this.monitor.ready(this.sender);
            }
        }
    }
}

