/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.io.File;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.UncheckedException;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.WorkerDaemon;
import org.gradle.workers.internal.WorkerDaemonAction;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerDaemonServer;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegate;
    private final WorkerDaemonFactory compilerDaemonFactory;
    private final File daemonWorkingDir;

    public AbstractDaemonCompiler(File daemonWorkingDir, Compiler<T> delegate, WorkerDaemonFactory compilerDaemonFactory) {
        this.daemonWorkingDir = daemonWorkingDir;
        this.delegate = delegate;
        this.compilerDaemonFactory = compilerDaemonFactory;
    }

    public Compiler<T> getDelegate() {
        return this.delegate;
    }

    public WorkResult execute(T spec) {
        DaemonForkOptions daemonForkOptions = this.toDaemonOptions(spec);
        WorkerDaemon daemon = this.compilerDaemonFactory.getDaemon(CompilerDaemonServer.class, this.daemonWorkingDir, daemonForkOptions);
        DefaultWorkResult result = daemon.execute(this.adapter(this.delegate), spec);
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    private CompilerWorkerAdapter<T> adapter(Compiler<T> compiler) {
        return new CompilerWorkerAdapter<T>(compiler);
    }

    protected abstract DaemonForkOptions toDaemonOptions(T var1);

    public static class CompilerDaemonServer
    extends WorkerDaemonServer {
        public <T extends WorkSpec> DefaultWorkResult execute(WorkerDaemonAction<T> action, T spec) {
            return super.execute(action, spec);
        }
    }

    private static class CompilerWorkerAdapter<T extends CompileSpec>
    implements WorkerDaemonAction<T> {
        private final Compiler<T> compiler;

        CompilerWorkerAdapter(Compiler<T> compiler) {
            this.compiler = compiler;
        }

        public DefaultWorkResult execute(T spec) {
            return new DefaultWorkResult(this.compiler.execute(spec).getDidWork(), null);
        }

        public String getDescription() {
            return this.compiler.getClass().getName();
        }
    }
}

