/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.collection.DependencyGraphTransformationContext;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.util.graph.transformer.ConflictMarker;
import org.sonatype.aether.util.graph.transformer.TransformationContextKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictIdSorter
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        Map conflictIds = (Map)context.get(TransformationContextKeys.CONFLICT_IDS);
        if (conflictIds == null) {
            ConflictMarker marker = new ConflictMarker();
            marker.transformGraph(node, context);
            conflictIds = (Map)context.get(TransformationContextKeys.CONFLICT_IDS);
        }
        LinkedHashMap<Object, ConflictId> ids = new LinkedHashMap<Object, ConflictId>(256);
        ConflictId id = null;
        Object key = conflictIds.get(node);
        if (key != null) {
            id = new ConflictId(key, 0);
            ids.put(key, id);
        }
        IdentityHashMap<DependencyNode, Object> visited = new IdentityHashMap<DependencyNode, Object>(conflictIds.size());
        this.buildConflitIdDAG(ids, node, id, 0, visited, conflictIds);
        this.topsortConflictIds(ids.values(), context);
        return node;
    }

    private void buildConflitIdDAG(Map<Object, ConflictId> ids, DependencyNode node, ConflictId id, int depth, Map<DependencyNode, Object> visited, Map<?, ?> conflictIds) {
        if (visited.put(node, Boolean.TRUE) != null) {
            return;
        }
        ++depth;
        for (DependencyNode child : node.getChildren()) {
            Object key = conflictIds.get(child);
            ConflictId childId = ids.get(key);
            if (childId == null) {
                childId = new ConflictId(key, depth);
                ids.put(key, childId);
            } else {
                childId.pullup(depth);
            }
            if (id != null) {
                id.add(childId);
            }
            this.buildConflitIdDAG(ids, child, childId, depth, visited, conflictIds);
        }
    }

    private void topsortConflictIds(Collection<ConflictId> conflictIds, DependencyGraphTransformationContext context) {
        boolean cycle;
        ArrayList<Object> sorted = new ArrayList<Object>(conflictIds.size());
        RootQueue roots = new RootQueue(conflictIds.size() / 2);
        for (ConflictId id : conflictIds) {
            if (id.inDegree > 0) continue;
            roots.add(id);
        }
        while (!roots.isEmpty()) {
            ConflictId root = roots.remove();
            sorted.add(root.key);
            for (ConflictId child : root.children) {
                --child.inDegree;
                if (child.inDegree != 0) continue;
                roots.add(child);
            }
        }
        boolean bl = cycle = sorted.size() < conflictIds.size();
        while (sorted.size() < conflictIds.size()) {
            ConflictId nearest = null;
            for (ConflictId id : conflictIds) {
                if (id.inDegree <= 0 || nearest != null && id.minDepth >= nearest.minDepth && (id.minDepth != nearest.minDepth || id.inDegree >= nearest.inDegree)) continue;
                nearest = id;
            }
            nearest.inDegree = 0;
            roots.add(nearest);
            while (!roots.isEmpty()) {
                ConflictId root = roots.remove();
                sorted.add(root.key);
                for (ConflictId child : root.children) {
                    --child.inDegree;
                    if (child.inDegree != 0) continue;
                    roots.add(child);
                }
            }
        }
        context.put(TransformationContextKeys.SORTED_CONFLICT_IDS, sorted);
        context.put(TransformationContextKeys.CYCLIC_CONFLICT_IDS, (Object)cycle);
    }

    static final class RootQueue {
        private int nextOut;
        private int nextIn;
        private ConflictId[] ids;

        RootQueue(int capacity) {
            this.ids = new ConflictId[capacity + 16];
        }

        boolean isEmpty() {
            return this.nextOut >= this.nextIn;
        }

        void add(ConflictId id) {
            if (this.nextOut >= this.nextIn && this.nextOut > 0) {
                this.nextIn -= this.nextOut;
                this.nextOut = 0;
            }
            if (this.nextIn >= this.ids.length) {
                ConflictId[] tmp = new ConflictId[this.ids.length + this.ids.length / 2 + 16];
                System.arraycopy(this.ids, this.nextOut, tmp, 0, this.nextIn - this.nextOut);
                this.ids = tmp;
                this.nextIn -= this.nextOut;
                this.nextOut = 0;
            }
            for (int i = this.nextIn - 1; i >= this.nextOut && id.minDepth < this.ids[i].minDepth; --i) {
                this.ids[i + 1] = this.ids[i];
            }
            this.ids[i + 1] = id;
            ++this.nextIn;
        }

        ConflictId remove() {
            return this.ids[this.nextOut++];
        }
    }

    static final class ConflictId {
        final Object key;
        Collection<ConflictId> children = Collections.emptySet();
        int inDegree;
        int minDepth;

        public ConflictId(Object key, int depth) {
            this.key = key;
            this.minDepth = depth;
        }

        public void add(ConflictId child) {
            if (this.children.isEmpty()) {
                this.children = new HashSet<ConflictId>();
            }
            if (this.children.add(child)) {
                ++child.inDegree;
            }
        }

        public void pullup(int depth) {
            if (depth < this.minDepth) {
                this.minDepth = depth++;
                for (ConflictId child : this.children) {
                    child.pullup(depth);
                }
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConflictId)) {
                return false;
            }
            ConflictId that = (ConflictId)obj;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key + " @ " + this.minDepth + " <" + this.inDegree;
        }
    }
}

