/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import java.io.EOFException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.descriptors.PackagePartProvider;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.PackageParts;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0013\u001a\u00020\u0012H\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lorg/jetbrains/kotlin/descriptors/PackagePartProvider;", "env", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "scope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;Lcom/intellij/psi/search/GlobalSearchScope;)V", "loadedModules", "", "Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider$ModuleMappingInfo;", "notLoadedRoots", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "getNotLoadedRoots", "()Ljava/util/List;", "notLoadedRoots$delegate", "Lkotlin/Lazy;", "findMetadataPackageParts", "", "", "packageFqName", "findPackageParts", "getPackageParts", "", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "processNotLoadedRelevantRoots", "", "ModuleMappingInfo", "kotlin-compiler"})
public final class JvmPackagePartProvider
implements PackagePartProvider {
    private final Lazy notLoadedRoots$delegate;
    private final List<ModuleMappingInfo> loadedModules;
    private final KotlinCoreEnvironment env;
    private final GlobalSearchScope scope;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    private final List<VirtualFile> getNotLoadedRoots() {
        Lazy lazy = this.notLoadedRoots$delegate;
        JvmPackagePartProvider jvmPackagePartProvider = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public List<String> findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Map<VirtualFile, PackageParts> rootToPackageParts = this.getPackageParts(packageFqName);
        if (rootToPackageParts.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        LinkedHashSet visitedMultifileFacades = new LinkedHashSet();
        Map<VirtualFile, PackageParts> map2 = rootToPackageParts;
        Iterator<Map.Entry<VirtualFile, PackageParts>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Iterable $receiver$iv;
            Map.Entry<VirtualFile, PackageParts> entry;
            Map.Entry<VirtualFile, PackageParts> entry2 = entry = iterator2.next();
            PackageParts packageParts = entry2.getValue();
            for (String name2 : packageParts.getParts()) {
                String facadeName = packageParts.getMultifileFacadeName(name2);
                if (facadeName != null && !(visitedMultifileFacades.contains(facadeName) ^ true)) continue;
                result2.add(name2);
            }
            Iterable $receiver$iv$iv = $receiver$iv = (Iterable)packageParts.getParts();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String string;
                Object element$iv = element$iv$iv;
                String p1 = (String)element$iv;
                if (packageParts.getMultifileFacadeName(p1) == null) continue;
                String it$iv = string;
                ((Collection)visitedMultifileFacades).add(it$iv);
            }
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> findMetadataPackageParts(@NotNull String packageFqName) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(packageFqName, "packageFqName");
        Iterable iterable = $receiver$iv = (Iterable)this.getPackageParts(packageFqName).values();
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object receiver = element$iv$iv = iterator2.next();
            Iterable list$iv$iv = ((PackageParts)receiver).getMetadataParts();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.distinct((List)destination$iv$iv);
    }

    private final synchronized Map<VirtualFile, PackageParts> getPackageParts(String packageFqName) {
        this.processNotLoadedRelevantRoots(packageFqName);
        Map result2 = new LinkedHashMap();
        for (ModuleMappingInfo moduleMappingInfo : this.loadedModules) {
            PackageParts newParts;
            VirtualFile root = moduleMappingInfo.component1();
            ModuleMapping mapping2 = moduleMappingInfo.component2();
            if (mapping2.findPackageParts(packageFqName) == null) {
                continue;
            }
            Object object = (PackageParts)result2.get(root);
            if (object != null) {
                PackageParts packageParts;
                PackageParts parts = packageParts = object;
                parts.plusAssign(newParts);
                object = Unit.INSTANCE;
                if (object != null) continue;
            }
            object = result2.put(root, newParts);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void processNotLoadedRelevantRoots(String packageFqName) {
        Object[] it;
        void $receiver$iv$iv;
        if (this.getNotLoadedRoots().isEmpty()) {
            return;
        }
        List pathParts = StringsKt.split$default((CharSequence)packageFqName, new char[]{'.'}, false, 0, 6, null);
        Iterable $receiver$iv = this.getNotLoadedRoots();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block12: {
                it = (Object[])element$iv$iv;
                Iterable $receiver$iv2 = pathParts;
                Object[] accumulator$iv = it;
                for (Object element$iv : $receiver$iv2) {
                    Object object;
                    void part;
                    String string = (String)element$iv;
                    Object[] parent2 = accumulator$iv;
                    CharSequence charSequence = (CharSequence)part;
                    if (charSequence.length() == 0) {
                        object = parent2;
                    } else {
                        object = parent2.findChild((String)part);
                        if (object == null) {
                            bl = false;
                            break block12;
                        }
                    }
                    accumulator$iv = object;
                }
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List relevantRoots = (List)destination$iv$iv;
        this.getNotLoadedRoots().removeAll(relevantRoots);
        for (VirtualFile root : relevantRoots) {
            void $receiver$iv$iv2;
            VirtualFile metaInf;
            Object[] $receiver$iv3;
            if (root.findChild("META-INF") == null) {
                continue;
            }
            it = $receiver$iv3 = (Object[])metaInf.getChildren();
            Collection destination$iv$iv2 = new ArrayList();
            for (int i = 0; i < ((void)$receiver$iv$iv2).length; ++i) {
                void element$iv$iv = $receiver$iv$iv2[i];
                VirtualFile it2 = (VirtualFile)element$iv$iv;
                if (!StringsKt.endsWith$default(it2.getName(), ModuleMapping.MAPPING_FILE_EXT, false, 2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List moduleFiles = (List)destination$iv$iv2;
            for (VirtualFile moduleFile : moduleFiles) {
                ModuleMapping moduleMapping;
                try {
                    moduleMapping = ModuleMapping.Companion.create(moduleFile.contentsToByteArray(), moduleFile.toString());
                }
                catch (EOFException e) {
                    throw (Throwable)new RuntimeException("Error on reading package parts for '" + packageFqName + "' package in '" + moduleFile + "', " + ("roots: " + this.getNotLoadedRoots()), e);
                }
                ModuleMapping mapping2 = moduleMapping;
                this.loadedModules.add(new ModuleMappingInfo(root, mapping2));
            }
        }
    }

    public JvmPackagePartProvider(@NotNull KotlinCoreEnvironment env, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkParameterIsNotNull(env, "env");
        Intrinsics.checkParameterIsNotNull(scope, "scope");
        this.env = env;
        this.scope = scope;
        this.notLoadedRoots$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<List<VirtualFile>>(this){
            final /* synthetic */ JvmPackagePartProvider this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<VirtualFile> invoke() {
                void var3_3;
                Object element$iv$iv2;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv = JvmPackagePartProvider.access$getEnv$p(this.this$0).getConfiguration().getList(JVMConfigurationKeys.CONTENT_ROOTS);
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (Object element$iv$iv2 : $receiver$iv$iv) {
                    if (!(element$iv$iv2 instanceof JvmClasspathRoot)) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
                element$iv$iv2 = $receiver$iv$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    VirtualFile virtualFile;
                    E element$iv$iv$iv;
                    E element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
                    JvmClasspathRoot it = (JvmClasspathRoot)element$iv$iv3;
                    if (JvmPackagePartProvider.access$getEnv$p(this.this$0).contentRootToVirtualFile(it) == null) continue;
                    VirtualFile it$iv$iv = virtualFile;
                    destination$iv$iv.add(it$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                for (Object element$iv$iv2 : $receiver$iv$iv) {
                    VirtualFile it = (VirtualFile)element$iv$iv2;
                    if (!(JvmPackagePartProvider.access$getScope$p(this.this$0).contains(it) && it.findChild("META-INF") != null)) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                return CollectionsKt.toMutableList((List)var3_3);
            }
            {
                this.this$0 = jvmPackagePartProvider;
                super(0);
            }
        });
        this.loadedModules = new SmartList();
    }

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Reflection.getOrCreateKotlinClass(JvmPackagePartProvider.class), "notLoadedRoots", "getNotLoadedRoots()Ljava/util/List;"))};
    }

    @NotNull
    public static final /* synthetic */ KotlinCoreEnvironment access$getEnv$p(JvmPackagePartProvider $this) {
        return $this.env;
    }

    @NotNull
    public static final /* synthetic */ GlobalSearchScope access$getScope$p(JvmPackagePartProvider $this) {
        return $this.scope;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider$ModuleMappingInfo;", "", "root", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "mapping", "Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;)V", "getMapping", "()Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-compiler"})
    private static final class ModuleMappingInfo {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final ModuleMapping mapping;

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final ModuleMapping getMapping() {
            return this.mapping;
        }

        public ModuleMappingInfo(@NotNull VirtualFile root, @NotNull ModuleMapping mapping2) {
            Intrinsics.checkParameterIsNotNull(root, "root");
            Intrinsics.checkParameterIsNotNull(mapping2, "mapping");
            this.root = root;
            this.mapping = mapping2;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final ModuleMapping component2() {
            return this.mapping;
        }

        @NotNull
        public final ModuleMappingInfo copy(@NotNull VirtualFile root, @NotNull ModuleMapping mapping2) {
            Intrinsics.checkParameterIsNotNull(root, "root");
            Intrinsics.checkParameterIsNotNull(mapping2, "mapping");
            return new ModuleMappingInfo(root, mapping2);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ModuleMappingInfo copy$default(ModuleMappingInfo moduleMappingInfo, VirtualFile virtualFile, ModuleMapping moduleMapping, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = moduleMappingInfo.root;
            }
            if ((n & 2) != 0) {
                moduleMapping = moduleMappingInfo.mapping;
            }
            return moduleMappingInfo.copy(virtualFile, moduleMapping);
        }

        public String toString() {
            return "ModuleMappingInfo(root=" + this.root + ", mapping=" + this.mapping + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile = this.root;
            ModuleMapping moduleMapping = this.mapping;
            return (virtualFile != null ? virtualFile.hashCode() : 0) * 31 + (moduleMapping != null ? moduleMapping.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModuleMappingInfo)) break block3;
                    ModuleMappingInfo moduleMappingInfo = (ModuleMappingInfo)object;
                    if (!Intrinsics.areEqual(this.root, moduleMappingInfo.root) || !Intrinsics.areEqual(this.mapping, moduleMappingInfo.mapping)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

