/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.base;

import java.util.Arrays;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;

public final class Objects {
    public static boolean equal(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(Objects.simpleName(self.getClass()));
    }

    public static ToStringHelper toStringHelper(String className2) {
        return new ToStringHelper(className2);
    }

    private static String simpleName(Class<?> clazz) {
        String name2 = clazz.getName();
        int start = (name2 = name2.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
        if (start == -1) {
            start = name2.lastIndexOf(46);
        }
        return name2.substring(start + 1);
    }

    public static final class ToStringHelper {
        private final String className;
        private ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(String className2) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(className2);
        }

        public ToStringHelper add(String name2, Object value) {
            return this.addHolder(name2, value);
        }

        public ToStringHelper add(String name2, boolean value) {
            return this.addHolder(name2, String.valueOf(value));
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            String nextSeparator = "";
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                if (!omitNullValuesSnapshot || valueHolder.value != null) {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                    if (valueHolder.name != null) {
                        builder.append(valueHolder.name).append('=');
                    }
                    builder.append(valueHolder.value);
                }
                valueHolder = valueHolder.next;
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(String name2, Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = value;
            valueHolder.name = Preconditions.checkNotNull(name2);
            return this;
        }

        private static final class ValueHolder {
            String name;
            Object value;
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

