/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import java.util.AbstractList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterAST;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.util.CharTable;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;

public class FCTSBackedLighterAST
extends LighterAST {
    @NotNull
    private final FlyweightCapableTreeStructure<LighterASTNode> myTreeStructure;

    public FCTSBackedLighterAST(@NotNull CharTable charTable, @NotNull FlyweightCapableTreeStructure<LighterASTNode> treeStructure) {
        if (charTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charTable", "org/jetbrains/kotlin/com/intellij/lang/FCTSBackedLighterAST", "<init>"));
        }
        if (treeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeStructure", "org/jetbrains/kotlin/com/intellij/lang/FCTSBackedLighterAST", "<init>"));
        }
        super(charTable);
        this.myTreeStructure = treeStructure;
    }

    @Override
    @NotNull
    public LighterASTNode getRoot() {
        LighterASTNode lighterASTNode = this.myTreeStructure.getRoot();
        if (lighterASTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/FCTSBackedLighterAST", "getRoot"));
        }
        return lighterASTNode;
    }

    @Override
    public LighterASTNode getParent(@NotNull LighterASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/com/intellij/lang/FCTSBackedLighterAST", "getParent"));
        }
        return this.myTreeStructure.getParent(node);
    }

    @Override
    @NotNull
    public List<LighterASTNode> getChildren(@NotNull LighterASTNode parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/com/intellij/lang/FCTSBackedLighterAST", "getChildren"));
        }
        Ref<T[]> into = new Ref<T[]>();
        int numKids = this.myTreeStructure.getChildren(this.myTreeStructure.prepareForGetChildren(parent2), into);
        if (numKids == 0) {
            List<LighterASTNode> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/FCTSBackedLighterAST", "getChildren"));
            }
            return list2;
        }
        LighterASTNode[] elements = (LighterASTNode[])into.get();
        assert (elements != null) : this.myTreeStructure + " (" + parent2 + ")";
        LighterASTNodeList lighterASTNodeList = new LighterASTNodeList(numKids, elements);
        if (lighterASTNodeList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/FCTSBackedLighterAST", "getChildren"));
        }
        return lighterASTNodeList;
    }

    @Override
    public void disposeChildren(@NotNull List<LighterASTNode> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "org/jetbrains/kotlin/com/intellij/lang/FCTSBackedLighterAST", "disposeChildren"));
        }
        if (children instanceof LighterASTNodeList) {
            LighterASTNodeList nodes = (LighterASTNodeList)children;
            this.myTreeStructure.disposeChildren((LighterASTNode[])nodes.myElements, nodes.mySize);
        } else {
            LighterASTNode[] astNodes = new LighterASTNode[children.size()];
            this.myTreeStructure.disposeChildren((LighterASTNode[])children.toArray(astNodes), astNodes.length);
        }
    }

    private static class LighterASTNodeList
    extends AbstractList<LighterASTNode> {
        private final int mySize;
        private final LighterASTNode[] myElements;

        public LighterASTNodeList(int size, LighterASTNode[] elements) {
            this.mySize = size;
            this.myElements = elements;
        }

        @Override
        public LighterASTNode get(int index2) {
            if (index2 < 0 || index2 >= this.mySize) {
                throw new IndexOutOfBoundsException("index:" + index2 + " size:" + this.mySize);
            }
            return this.myElements[index2];
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }
}

