/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions;

import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gnu.trove.THashMap;

public class PluginId
implements Comparable<PluginId> {
    public static final PluginId[] EMPTY_ARRAY = new PluginId[0];
    private static final Map<String, PluginId> ourRegisteredIds = new THashMap<String, PluginId>();
    private final String myIdString;

    private PluginId(@NotNull String idString) {
        if (idString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idString", "org/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId", "<init>"));
        }
        this.myIdString = idString;
    }

    @Override
    public int compareTo(@NotNull PluginId o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "org/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId", "compareTo"));
        }
        return this.myIdString.compareTo(o.myIdString);
    }

    @NotNull
    public static synchronized PluginId getId(@NotNull String idString) {
        if (idString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idString", "org/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId", "getId"));
        }
        PluginId pluginId = ourRegisteredIds.get(idString);
        if (pluginId == null) {
            pluginId = new PluginId(idString);
            ourRegisteredIds.put(idString, pluginId);
        }
        PluginId pluginId2 = pluginId;
        if (pluginId2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId", "getId"));
        }
        return pluginId2;
    }

    @NonNls
    @NotNull
    public String getIdString() {
        String string = this.myIdString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/extensions/PluginId", "getIdString"));
        }
        return string;
    }

    public String toString() {
        return this.getIdString();
    }
}

