/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.AreaInstance;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.impl.PackageDirectoryCache;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFinder;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.impl.file.PsiPackageImpl;
import org.jetbrains.kotlin.com.intellij.psi.search.EverythingGlobalScope;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.NonClasspathDirectoriesScope;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusConnection;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    private static final EverythingGlobalScope ALL_SCOPE = new EverythingGlobalScope();
    protected final Project myProject;
    private volatile PackageDirectoryCache myCache;
    private final PsiManager myManager;
    private final String[] myFileExtensions;

    public NonClasspathClassFinder(Project project, String ... fileExtensions) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance(this.myProject);
        this.myFileExtensions = ArrayUtil.append(fileExtensions, "class");
        MessageBusConnection connection = project.getMessageBus().connect(project);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener.Adapter(){

            @Override
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder$1", "after"));
                }
                NonClasspathClassFinder.this.clearCache();
            }
        });
    }

    @NotNull
    protected PackageDirectoryCache getCache(@Nullable GlobalSearchScope scope) {
        PackageDirectoryCache cache2 = this.myCache;
        if (cache2 == null) {
            this.myCache = cache2 = NonClasspathClassFinder.createCache(this.calcClassRoots());
        }
        PackageDirectoryCache packageDirectoryCache = cache2;
        if (packageDirectoryCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getCache"));
        }
        return packageDirectoryCache;
    }

    @NotNull
    protected static PackageDirectoryCache createCache(@NotNull List<VirtualFile> roots2) {
        if (roots2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "createCache"));
        }
        MultiMap<String, VirtualFile> map2 = MultiMap.create();
        map2.putValues("", roots2);
        PackageDirectoryCache packageDirectoryCache = new PackageDirectoryCache(map2);
        if (packageDirectoryCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "createCache"));
        }
        return packageDirectoryCache;
    }

    public void clearCache() {
        this.myCache = null;
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope) {
        return this.getCache(scope).getDirectoriesByPackageName("");
    }

    public List<VirtualFile> getClassRoots() {
        return this.getClassRoots(ALL_SCOPE);
    }

    @Override
    public PsiClass findClass(final @NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findClass"));
        }
        final Ref result2 = Ref.create();
        this.processDirectories(StringUtil.getPackageName(qualifiedName2), scope, new Processor<VirtualFile>(){

            @Override
            public boolean process(VirtualFile dir) {
                PsiClass[] classes2;
                PsiFile file2;
                VirtualFile virtualFile = NonClasspathClassFinder.findChild(dir, StringUtil.getShortName(qualifiedName2), NonClasspathClassFinder.this.myFileExtensions);
                PsiFile psiFile = file2 = virtualFile == null ? null : NonClasspathClassFinder.this.myManager.findFile(virtualFile);
                if (file2 instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)file2).getClasses()).length == 1) {
                    result2.set(classes2[0]);
                    return false;
                }
                return true;
            }
        });
        return (PsiClass)result2.get();
    }

    protected abstract List<VirtualFile> calcClassRoots();

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        final ArrayList<PsiClass> result2 = ContainerUtil.newArrayList();
        this.processDirectories(psiPackage.getQualifiedName(), scope, new Processor<VirtualFile>(){

            @Override
            public boolean process(VirtualFile dir) {
                for (VirtualFile file2 : dir.getChildren()) {
                    PsiFile psi;
                    if (file2.isDirectory() || !ArrayUtil.contains(file2.getExtension(), NonClasspathClassFinder.this.myFileExtensions) || !((psi = NonClasspathClassFinder.this.myManager.findFile(file2)) instanceof PsiClassOwner)) continue;
                    ContainerUtil.addAll(result2, ((PsiClassOwner)psi).getClasses());
                }
                return true;
            }
        });
        PsiClass[] psiClassArray = result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        final HashSet<String> result2 = new HashSet<String>();
        this.processDirectories(psiPackage.getQualifiedName(), scope, new Processor<VirtualFile>(){

            @Override
            public boolean process(VirtualFile dir) {
                for (VirtualFile file2 : dir.getChildren()) {
                    if (file2.isDirectory() || !ArrayUtil.contains(file2.getExtension(), NonClasspathClassFinder.this.myFileExtensions)) continue;
                    result2.add(file2.getNameWithoutExtension());
                }
                return true;
            }
        });
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getClassNames"));
        }
        return hashSet;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findPackage"));
        }
        CommonProcessors.FindFirstProcessor<VirtualFile> processor = new CommonProcessors.FindFirstProcessor<VirtualFile>();
        this.processDirectories(qualifiedName2, ALL_SCOPE, processor);
        return processor.getFoundValue() != null ? this.createPackage(qualifiedName2) : null;
    }

    private PsiPackageImpl createPackage(String qualifiedName2) {
        return new PsiPackageImpl(this.myManager, qualifiedName2);
    }

    @Override
    public boolean processPackageDirectories(final @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, final @NotNull Processor<PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "processPackageDirectories"));
        }
        return this.processDirectories(psiPackage.getQualifiedName(), scope, new Processor<VirtualFile>(){

            @Override
            public boolean process(VirtualFile dir) {
                PsiDirectory psiDirectory = psiPackage.getManager().findDirectory(dir);
                return psiDirectory == null || consumer.process(psiDirectory);
            }
        });
    }

    private boolean processDirectories(@NotNull String qualifiedName2, final @NotNull GlobalSearchScope scope, final @NotNull Processor<VirtualFile> processor) {
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "processDirectories"));
        }
        return ContainerUtil.process(this.getCache(scope).getDirectoriesByPackageName(qualifiedName2), new Processor<VirtualFile>(){

            @Override
            public boolean process(VirtualFile file2) {
                return !scope.contains(file2) || processor.process(file2);
            }
        });
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiPackage", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        String pkgName = psiPackage.getQualifiedName();
        Set<String> names2 = this.getCache(scope).getSubpackageNames(pkgName);
        if (names2.isEmpty()) {
            PsiPackage[] psiPackageArray = super.getSubPackages(psiPackage, scope);
            if (psiPackageArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
            }
            return psiPackageArray;
        }
        ArrayList<PsiPackageImpl> result2 = new ArrayList<PsiPackageImpl>();
        for (String name2 : names2) {
            result2.add(this.createPackage(pkgName.isEmpty() ? name2 : pkgName + "." + name2));
        }
        PsiPackage[] psiPackageArray = result2.toArray(new PsiPackage[result2.size()]);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName2, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (qualifiedName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        PsiClass psiClass = this.findClass(qualifiedName2, scope);
        if (psiClass == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findClasses"));
        }
        return psiClassArray;
    }

    @NotNull
    public static GlobalSearchScope addNonClasspathScope(@NotNull Project project, @NotNull GlobalSearchScope base) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        GlobalSearchScope scope = base;
        for (PsiElementFinder finder : (PsiElementFinder[])Extensions.getExtensions(EP_NAME, (AreaInstance)project)) {
            if (!(finder instanceof NonClasspathClassFinder)) continue;
            scope = scope.uniteWith(NonClasspathDirectoriesScope.compose(((NonClasspathClassFinder)finder).getClassRoots()));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "addNonClasspathScope"));
        }
        return globalSearchScope;
    }

    public PsiManager getPsiManager() {
        return this.myManager;
    }

    @Nullable
    private static VirtualFile findChild(@NotNull VirtualFile root, @NotNull String relPath, @NotNull String[] extensions) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        if (relPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relPath", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "org/jetbrains/kotlin/com/intellij/psi/NonClasspathClassFinder", "findChild"));
        }
        VirtualFile file2 = null;
        for (String extension : extensions) {
            file2 = root.findChild(relPath + '.' + extension);
            if (file2 != null) break;
        }
        return file2;
    }
}

