/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.controlFlow;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowStack;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.GoToInstruction;

public class CallInstruction
extends GoToInstruction {
    public final ControlFlowStack stack;
    public int procBegin;
    public int procEnd;

    public CallInstruction(int procBegin, int procEnd, @NotNull ControlFlowStack stack) {
        if (stack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "org/jetbrains/kotlin/com/intellij/psi/controlFlow/CallInstruction", "<init>"));
        }
        super(procBegin);
        this.stack = stack;
        this.procBegin = procBegin;
        this.procEnd = procEnd;
    }

    @Override
    public String toString() {
        return "CALL " + this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(int returnOffset) {
        ControlFlowStack controlFlowStack = this.stack;
        synchronized (controlFlowStack) {
            this.stack.push(returnOffset, this);
        }
    }

    @Override
    public void accept(ControlFlowInstructionVisitor visitor2, int offset2, int nextOffset) {
        visitor2.visitCallInstruction(this, offset2, nextOffset);
    }
}

