/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.CharSequenceWithStringHash;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.kotlin.com.intellij.util.text.StringFactory;

public class ByteArrayCharSequence
implements CharSequenceWithStringHash {
    private int hash;
    private final byte[] myChars;

    private ByteArrayCharSequence(@NotNull byte[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "org/jetbrains/kotlin/com/intellij/util/text/ByteArrayCharSequence", "<init>"));
        }
        this.myChars = chars;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public final int length() {
        return this.myChars.length;
    }

    @Override
    public final char charAt(int index2) {
        return (char)this.myChars[index2];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        CharSequenceWithStringHash charSequenceWithStringHash = start == 0 && end == this.length() ? this : new CharSequenceSubSequence(this, start, end);
        if (charSequenceWithStringHash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ByteArrayCharSequence", "subSequence"));
        }
        return charSequenceWithStringHash;
    }

    @Override
    @NotNull
    public String toString() {
        String string = StringFactory.createShared(CharArrayUtil.fromSequence(this, 0, this.length()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ByteArrayCharSequence", "toString"));
        }
        return string;
    }

    @NotNull
    public static CharSequence convertToBytesIfAsciiString(@NotNull CharSequence name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/util/text/ByteArrayCharSequence", "convertToBytesIfAsciiString"));
        }
        int length = name2.length();
        if (length == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ByteArrayCharSequence", "convertToBytesIfAsciiString"));
            }
            return "";
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = name2.charAt(i);
            if (c >= '\u0080') {
                String string = new String(name2.toString());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ByteArrayCharSequence", "convertToBytesIfAsciiString"));
                }
                return string;
            }
            bytes[i] = (byte)c;
        }
        ByteArrayCharSequence byteArrayCharSequence = new ByteArrayCharSequence(bytes);
        if (byteArrayCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/text/ByteArrayCharSequence", "convertToBytesIfAsciiString"));
        }
        return byteArrayCharSequence;
    }
}

