/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.text.CharSequenceSubSequence;

public abstract class ImmutableCharSequence
implements CharSequence {
    public static CharSequence asImmutable(@NotNull CharSequence cs) {
        if (cs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cs", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableCharSequence", "asImmutable"));
        }
        return ImmutableCharSequence.isImmutable(cs) ? cs : cs.toString();
    }

    public static boolean isImmutable(@NotNull CharSequence cs) {
        if (cs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cs", "org/jetbrains/kotlin/com/intellij/util/text/ImmutableCharSequence", "isImmutable"));
        }
        if (cs instanceof ImmutableCharSequence) {
            return true;
        }
        if (cs instanceof CharSequenceSubSequence) {
            return ImmutableCharSequence.isImmutable(((CharSequenceSubSequence)cs).getBaseSequence());
        }
        return false;
    }
}

