/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.common.Symbol;

public final class JsParameter
extends SourceInfoAwareJsNode
implements HasName {
    @NotNull
    private JsName name;

    public JsParameter(@NotNull JsName name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/backend/ast/JsParameter", "<init>"));
        }
        this.name = name2;
    }

    @Override
    @NotNull
    public JsName getName() {
        JsName jsName = this.name;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsParameter", "getName"));
        }
        return jsName;
    }

    @Override
    public void setName(@NotNull JsName name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/js/backend/ast/JsParameter", "setName"));
        }
        this.name = name2;
    }

    @Override
    @NotNull
    public Symbol getSymbol() {
        JsName jsName = this.name;
        if (jsName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsParameter", "getSymbol"));
        }
        return jsName;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitParameter(this);
    }

    @Override
    public void traverse(JsVisitorWithContext v, JsContext ctx) {
        v.visit(this, ctx);
        v.endVisit(this, ctx);
    }

    @Override
    @NotNull
    public JsParameter deepCopy() {
        JsParameter jsParameter = new JsParameter(this.name).withMetadataFrom(this);
        if (jsParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsParameter", "deepCopy"));
        }
        return jsParameter;
    }
}

