/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.IncrementTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;

public final class UnaryOperationTranslator {
    private UnaryOperationTranslator() {
    }

    @NotNull
    public static JsExpression translate(@NotNull KtUnaryExpression expression, @NotNull TranslationContext context) {
        Object baseExpression;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        IElementType operationToken = expression.getOperationReference().getReferencedNameElementType();
        if (operationToken == KtTokens.EXCLEXCL) {
            KtExpression baseExpression2 = PsiUtils.getBaseExpression(expression);
            JsExpression translatedExpression = Translation.translateAsExpression(baseExpression2, context);
            JsConditional jsConditional = TranslationUtils.sure(translatedExpression, context);
            if (jsConditional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsConditional;
        }
        if (operationToken == KtTokens.MINUS && (baseExpression = PsiUtils.getBaseExpression(expression)) instanceof KtConstantExpression) {
            CompileTimeConstant<?> compileTimeValue = ConstantExpressionEvaluator.getConstant(expression, context.bindingContext());
            assert (compileTimeValue != null) : ErrorReportingUtils.message(expression, "Expression is not compile time value: " + expression.getText() + " ");
            Object value = BindingUtils.getCompileTimeValue(context.bindingContext(), expression, compileTimeValue);
            if (value instanceof Long) {
                JsExpression jsExpression = JsAstUtils.newLong((Long)value, context);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
                }
                return jsExpression;
            }
        }
        if (IncrementTranslator.isIncrement(operationToken)) {
            JsExpression jsExpression = IncrementTranslator.translate(expression, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        baseExpression = TranslationUtils.translateBaseExpression(context, expression);
        if (UnaryOperationTranslator.isExclForBinaryEqualLikeExpr(expression, (JsExpression)baseExpression)) {
            JsExpression jsExpression = TranslationUtils.translateExclForBinaryEqualLikeExpr((JsBinaryOperation)baseExpression);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
            }
            return jsExpression;
        }
        ResolvedCall<? extends FunctionDescriptor> resolvedCall2 = CallUtilKt.getFunctionResolvedCallWithAssert(expression, context.bindingContext());
        JsExpression jsExpression = CallTranslator.translate(context, resolvedCall2, (JsExpression)baseExpression);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "translate"));
        }
        return jsExpression;
    }

    private static boolean isExclForBinaryEqualLikeExpr(@NotNull KtUnaryExpression expression, @NotNull JsExpression baseExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "isExclForBinaryEqualLikeExpr"));
        }
        if (baseExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseExpression", "org/jetbrains/kotlin/js/translate/operation/UnaryOperationTranslator", "isExclForBinaryEqualLikeExpr"));
        }
        if (PsiUtils.getOperationToken(expression).equals(KtTokens.EXCL) && baseExpression instanceof JsBinaryOperation) {
            return TranslationUtils.isEqualLikeOperator(((JsBinaryOperation)baseExpression).getOperator());
        }
        return false;
    }
}

