/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.picocontainer.defaults;

import org.jetbrains.kotlin.org.picocontainer.ComponentMonitor;
import org.jetbrains.kotlin.org.picocontainer.defaults.AssignabilityRegistrationException;
import org.jetbrains.kotlin.org.picocontainer.defaults.DelegatingComponentMonitor;
import org.jetbrains.kotlin.org.picocontainer.defaults.MonitoringComponentAdapter;

public abstract class AbstractComponentAdapter
extends MonitoringComponentAdapter {
    private Object componentKey;
    private Class componentImplementation;

    protected AbstractComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException {
        this(componentKey, componentImplementation, new DelegatingComponentMonitor());
    }

    protected AbstractComponentAdapter(Object componentKey, Class componentImplementation, ComponentMonitor monitor) throws AssignabilityRegistrationException {
        super(monitor);
        if (componentImplementation == null) {
            throw new NullPointerException("componentImplementation");
        }
        this.componentKey = componentKey;
        this.componentImplementation = componentImplementation;
        this.checkTypeCompatibility();
    }

    @Override
    public Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    @Override
    public Class getComponentImplementation() {
        return this.componentImplementation;
    }

    protected void checkTypeCompatibility() throws AssignabilityRegistrationException {
        Class componentType;
        if (this.componentKey instanceof Class && !(componentType = (Class)this.componentKey).isAssignableFrom(this.componentImplementation)) {
            throw new AssignabilityRegistrationException(componentType, this.componentImplementation);
        }
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getName()).append("[").append(this.getComponentKey()).append("]").toString();
    }
}

