/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationWithTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnnotationUseSiteTarget;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.AnnotationUseSiteTargetChecker$WhenMappings;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\f\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\u000f\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0010\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0013\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u000eH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/AnnotationUseSiteTargetChecker;", "", "()V", "check", "", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkDeclaration", "checkIfDelegatedProperty", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "checkIfHasBackingField", "checkIfMutableProperty", "checkIfProperty", "", "checkReceiverAnnotations", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "useSiteDescription", "", "kotlin-compiler"})
public final class AnnotationUseSiteTargetChecker {
    public static final AnnotationUseSiteTargetChecker INSTANCE;

    public final void check(@NotNull KtAnnotated annotated, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(annotated, "annotated");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        this.checkDeclaration(trace, annotated, descriptor2);
        if (annotated instanceof KtFunction) {
            for (KtParameter parameter : ((KtFunction)annotated).getValueParameters()) {
                VariableDescriptor parameterDescriptor;
                if (parameter.hasValOrVar()) continue;
                if ((VariableDescriptor)trace.getBindingContext().get(BindingContext.VALUE_PARAMETER, parameter) == null) {
                    continue;
                }
                KtParameter ktParameter = parameter;
                Intrinsics.checkExpressionValueIsNotNull(ktParameter, "parameter");
                KtAnnotated ktAnnotated = ktParameter;
                VariableDescriptor variableDescriptor = parameterDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(variableDescriptor, "parameterDescriptor");
                this.checkDeclaration(trace, ktAnnotated, variableDescriptor);
            }
        }
        if (descriptor2 instanceof CallableDescriptor) {
            this.checkReceiverAnnotations(trace, (CallableDescriptor)descriptor2);
        }
    }

    private final void checkReceiverAnnotations(@NotNull BindingTrace $receiver, CallableDescriptor descriptor2) {
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return;
        }
        ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
        block6: for (AnnotationWithTarget annotationWithTarget : extensionReceiver.getType().getAnnotations().getUseSiteTargetedAnnotations()) {
            AnnotationUseSiteTarget target;
            if (annotationWithTarget.getTarget() == null) {
                continue;
            }
            Function0<KtAnnotationEntry> annotationEntry$ = new Function0<KtAnnotationEntry>(annotationWithTarget){
                final /* synthetic */ AnnotationWithTarget $annotationWithTarget;

                @Nullable
                public final KtAnnotationEntry invoke() {
                    return DescriptorToSourceUtils.getSourceFromAnnotation(this.$annotationWithTarget.getAnnotation());
                }
                {
                    this.$annotationWithTarget = annotationWithTarget;
                    super(0);
                }
            };
            switch (AnnotationUseSiteTargetChecker$WhenMappings.$EnumSwitchMapping$0[target.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Object object;
                    if (annotationEntry$.invoke() == null) continue block6;
                    KtAnnotationEntry it = (KtAnnotationEntry)object;
                    $receiver.report(Errors.INAPPLICABLE_TARGET_ON_PROPERTY.on(it, target.getRenderName()));
                    break;
                }
                case 8: {
                    Object object;
                    if (annotationEntry$.invoke() == null) continue block6;
                    KtAnnotationEntry it = (KtAnnotationEntry)object;
                    $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on(it));
                    break;
                }
                case 9: {
                    throw (Throwable)new IllegalArgumentException("@file annotations are not allowed here");
                }
            }
        }
    }

    private final void checkDeclaration(@NotNull BindingTrace $receiver, KtAnnotated annotated, DeclarationDescriptor descriptor2) {
        block10: for (KtAnnotationEntry annotation2 : annotated.getAnnotationEntries()) {
            Object object = annotation2.getUseSiteTarget();
            if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null) {
                continue;
            }
            Object target = object;
            switch (AnnotationUseSiteTargetChecker$WhenMappings.$EnumSwitchMapping$1[((Enum)target).ordinal()]) {
                case 1: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfHasBackingField($receiver, annotated, descriptor2, ktAnnotationEntry);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfDelegatedProperty($receiver, annotated, ktAnnotationEntry);
                    break;
                }
                case 5: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfMutableProperty($receiver, annotated, ktAnnotationEntry);
                    break;
                }
                case 6: {
                    DeclarationDescriptor containingDeclaration;
                    if (!(annotated instanceof KtParameter)) {
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation2));
                        break;
                    }
                    VariableDescriptor variableDescriptor = (VariableDescriptor)$receiver.getBindingContext().get(BindingContext.VALUE_PARAMETER, annotated);
                    DeclarationDescriptor declarationDescriptor = containingDeclaration = variableDescriptor != null ? variableDescriptor.getContainingDeclaration() : null;
                    if (!(containingDeclaration instanceof ConstructorDescriptor) || !((ConstructorDescriptor)containingDeclaration).isPrimary()) {
                        $receiver.report(Errors.INAPPLICABLE_PARAM_TARGET.on(annotation2));
                        break;
                    }
                    if (((KtParameter)annotated).hasValOrVar()) continue block10;
                    $receiver.report(Errors.REDUNDANT_ANNOTATION_TARGET.on(annotation2, ((AnnotationUseSiteTarget)((Object)target)).getRenderName()));
                    break;
                }
                case 7: {
                    KtAnnotationEntry ktAnnotationEntry = annotation2;
                    Intrinsics.checkExpressionValueIsNotNull(ktAnnotationEntry, "annotation");
                    this.checkIfMutableProperty($receiver, annotated, ktAnnotationEntry);
                    break;
                }
                case 8: {
                    throw (Throwable)new IllegalArgumentException("@file annotations are not allowed here");
                }
                case 9: {
                    $receiver.report(Errors.INAPPLICABLE_RECEIVER_TARGET.on(annotation2));
                }
            }
        }
    }

    private final void checkIfDelegatedProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && !((KtProperty)annotated).hasDelegate() || annotated instanceof KtParameter && ((KtParameter)annotated).hasValOrVar()) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_DELEGATE.on(annotation2));
        }
    }

    private final void checkIfHasBackingField(@NotNull BindingTrace $receiver, KtAnnotated annotated, DeclarationDescriptor descriptor2, KtAnnotationEntry annotation2) {
        if (annotated instanceof KtProperty && ((KtProperty)annotated).hasDelegate() && descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual((Boolean)$receiver.get(BindingContext.BACKING_FIELD_REQUIRED, descriptor2), true) ^ true) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_HAS_NO_BACKING_FIELD.on(annotation2));
        }
    }

    private final String useSiteDescription(@NotNull KtAnnotationEntry $receiver) {
        Object object = $receiver.getUseSiteTarget();
        if (object == null || (object = ((KtAnnotationUseSiteTarget)object).getAnnotationUseSiteTarget()) == null || (object = ((AnnotationUseSiteTarget)((Object)object)).getRenderName()) == null) {
            object = "unknown target";
        }
        return object;
    }

    private final void checkIfMutableProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isMutable;
        if (!this.checkIfProperty($receiver, annotated, annotation2)) {
            return;
        }
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? ((KtProperty)annotated).isVar() : (isMutable = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).isMutable() : false);
        if (!isMutable) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_PROPERTY_IMMUTABLE.on(annotation2, this.useSiteDescription(annotation2)));
        }
    }

    private final boolean checkIfProperty(@NotNull BindingTrace $receiver, KtAnnotated annotated, KtAnnotationEntry annotation2) {
        boolean isProperty;
        KtAnnotated ktAnnotated = annotated;
        boolean bl = ktAnnotated instanceof KtProperty ? !((KtProperty)annotated).isLocal() : (isProperty = ktAnnotated instanceof KtParameter ? ((KtParameter)annotated).hasValOrVar() : false);
        if (!isProperty) {
            $receiver.report(Errors.INAPPLICABLE_TARGET_ON_PROPERTY.on(annotation2, this.useSiteDescription(annotation2)));
        }
        return isProperty;
    }

    private AnnotationUseSiteTargetChecker() {
        INSTANCE = this;
    }

    static {
        new AnnotationUseSiteTargetChecker();
    }
}

