/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.platform.JvmBuiltIns;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.MultiTargetPlatform;
import org.jetbrains.kotlin.resolve.PlatformConfigurator;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformConfigurator;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/platform/JvmPlatform;", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "()V", "multiTargetPlatform", "Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "getMultiTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/MultiTargetPlatform$Specific;", "platformConfigurator", "Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getPlatformConfigurator", "()Lorg/jetbrains/kotlin/resolve/PlatformConfigurator;", "getDefaultImports", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "kotlin-compiler"})
public final class JvmPlatform
extends TargetPlatform {
    @NotNull
    private static final PlatformConfigurator platformConfigurator;
    @NotNull
    private static final MultiTargetPlatform.Specific multiTargetPlatform;
    public static final JvmPlatform INSTANCE;

    @Override
    @NotNull
    public List<ImportPath> getDefaultImports(@NotNull LanguageVersionSettings languageVersionSettings) {
        ArrayList<ImportPath> arrayList;
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        ArrayList<ImportPath> $receiver = arrayList = new ArrayList<ImportPath>();
        $receiver.addAll((Collection)TargetPlatform.Default.INSTANCE.getDefaultImports(languageVersionSettings));
        $receiver.add(new ImportPath("java.lang.*"));
        $receiver.add(new ImportPath("kotlin.jvm.*"));
        Function1<MemberScope, Unit> addAllClassifiersFromScope$ = new Function1<MemberScope, Unit>($receiver){
            final /* synthetic */ ArrayList receiver$0;

            public final void invoke(@NotNull MemberScope scope) {
                Intrinsics.checkParameterIsNotNull(scope, "scope");
                for (DeclarationDescriptor descriptor2 : scope.getContributedDescriptors(DescriptorKindFilter.CLASSIFIERS, MemberScope.Companion.getALL_NAME_FILTER())) {
                    this.receiver$0.add(new ImportPath(DescriptorUtils.getFqNameSafe(descriptor2), false));
                }
            }
            {
                this.receiver$0 = arrayList;
                super(1);
            }
        };
        StorageManager storageManager = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkExpressionValueIsNotNull(storageManager, "LockBasedStorageManager.NO_LOCKS");
        JvmBuiltIns builtIns = new JvmBuiltIns(storageManager, false, 2, null);
        for (PackageFragmentDescriptor builtinPackageFragment : builtIns.getBuiltInsPackageFragmentsImportedByDefault()) {
            addAllClassifiersFromScope$.invoke(builtinPackageFragment.getMemberScope());
        }
        return arrayList;
    }

    @Override
    @NotNull
    public PlatformConfigurator getPlatformConfigurator() {
        return platformConfigurator;
    }

    @Override
    @NotNull
    public MultiTargetPlatform.Specific getMultiTargetPlatform() {
        return multiTargetPlatform;
    }

    private JvmPlatform() {
        super("JVM");
        INSTANCE = this;
        platformConfigurator = JvmPlatformConfigurator.INSTANCE;
        multiTargetPlatform = new MultiTargetPlatform.Specific(this.getPlatformName());
    }

    static {
        new JvmPlatform();
    }
}

