/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ParamSpec;
import org.gradle.workers.internal.WorkerDaemonAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDaemonRunnableAction
implements WorkerDaemonAction<ParamSpec> {
    private final String description;
    private final Class<? extends Runnable> runnableClass;

    WorkerDaemonRunnableAction(String description, Class<? extends Runnable> runnableClass) {
        this.description = description;
        this.runnableClass = runnableClass;
    }

    @Override
    public DefaultWorkResult execute(ParamSpec spec) {
        try {
            Runnable runnable = (Runnable)DirectInstantiator.instantiate(this.runnableClass, (Object[])spec.getParams());
            runnable.run();
            return new DefaultWorkResult(true, null);
        }
        catch (ObjectInstantiationException e) {
            return new DefaultWorkResult(true, e.getCause());
        }
        catch (Throwable t) {
            return new DefaultWorkResult(true, t);
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

