/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.WorkerDaemonAction;
import org.gradle.workers.internal.WorkerDaemonProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDaemonServer
implements WorkerDaemonProtocol {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonServer.class);

    @Override
    public <T extends WorkSpec> DefaultWorkResult execute(WorkerDaemonAction<T> action, T spec) {
        try {
            LOGGER.info("Executing {} in worker daemon.", (Object)action.getDescription());
            DefaultWorkResult result = action.execute(spec);
            LOGGER.info("Successfully executed {} in worker daemon.", (Object)action.getDescription());
            return result;
        }
        catch (Throwable t) {
            LOGGER.info("Exception executing {} in worker daemon: {}.", (Object)action.getDescription(), (Object)t);
            return new DefaultWorkResult(true, t);
        }
    }

    public String toString() {
        return "WorkerDaemonServer{}";
    }
}

