/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.util.Arrays;
import java.util.List;

public class JvmPackageName {
    private static final List<String> JAVA_KEYWORDS = Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while");
    private static final List<String> BOOLEAN_AND_NULL_LITERALS = Arrays.asList("true", "false", "null");
    private static final String UNNAMED_PACKAGE = "";
    private final String value;

    private JvmPackageName(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static JvmPackageName of(String value) {
        if (!JvmPackageName.isValidPackageName(value)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid package name", value));
        }
        return new JvmPackageName(value);
    }

    private static boolean isValidPackageName(String value) {
        if (UNNAMED_PACKAGE.equals(value)) {
            return true;
        }
        if (value == null || value.startsWith(".") || value.endsWith(".")) {
            return false;
        }
        for (String token : value.split("\\.")) {
            if (JvmPackageName.isIdentifier(token)) continue;
            return false;
        }
        return true;
    }

    private static boolean isIdentifier(String token) {
        if (token.isEmpty() || JAVA_KEYWORDS.contains(token) || BOOLEAN_AND_NULL_LITERALS.contains(token) || !Character.isJavaIdentifierStart(token.charAt(0))) {
            return false;
        }
        if (token.length() > 1) {
            for (char c : token.substring(1).toCharArray()) {
                if (Character.isJavaIdentifierPart(c)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmPackageName that = (JvmPackageName)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

