/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.InstalledJdk;
import org.gradle.model.Managed;

@Managed
public abstract class InstalledJdkInternal
implements InstalledJdk {
    private static File getBinDir(InstalledJdk jdk) {
        return new File(jdk.getJavaHome(), "bin");
    }

    private static File getExecutable(InstalledJdk jdk, String name) {
        return new File(InstalledJdkInternal.getBinDir(jdk), OperatingSystem.current().getExecutableName(name));
    }

    public File getJavaExecutable() {
        return InstalledJdkInternal.getExecutable(this, "java");
    }

    public File getJavaCompileExecutable() {
        return InstalledJdkInternal.getExecutable(this, "javac");
    }

    public File getJavadocExecutable() {
        return InstalledJdkInternal.getExecutable(this, "javadoc");
    }
}

