/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal.feature;

import org.gradle.testkit.runner.UnsupportedFeatureException;
import org.gradle.testkit.runner.internal.feature.FeatureCheck;
import org.gradle.testkit.runner.internal.feature.TestKitFeature;
import org.gradle.util.GradleVersion;

public class BuildResultOutputFeatureCheck
implements FeatureCheck {
    private final GradleVersion targetGradleVersion;
    private final boolean embedded;

    public BuildResultOutputFeatureCheck(GradleVersion targetGradleVersion, boolean embedded) {
        this.targetGradleVersion = targetGradleVersion;
        this.embedded = embedded;
    }

    @Override
    public void verify() {
        if (!this.supportsVersion() && this.embedded) {
            throw new UnsupportedFeatureException("capture build output in debug mode with the GradleRunner", this.targetGradleVersion, TestKitFeature.CAPTURE_BUILD_RESULT_OUTPUT_IN_DEBUG.getSince());
        }
    }

    private boolean supportsVersion() {
        return this.targetGradleVersion.compareTo(TestKitFeature.CAPTURE_BUILD_RESULT_OUTPUT_IN_DEBUG.getSince()) >= 0;
    }
}

