/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.announce.internal;

import java.util.ArrayList;
import java.util.List;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.plugins.announce.Announcer;
import org.gradle.api.tasks.TaskState;

public class AnnouncingBuildListener
extends BuildAdapter
implements TaskExecutionListener {
    private final Announcer announcer;
    private List<Task> failed = new ArrayList<Task>();
    private Task lastFailed;
    private int taskCount;

    public AnnouncingBuildListener(Announcer announcer) {
        this.announcer = announcer;
    }

    public void beforeExecute(Task task) {
        ++this.taskCount;
        if (this.lastFailed != null) {
            this.announcer.send(this.lastFailed + " failed", this.getTaskFailureCountMessage());
            this.lastFailed = null;
        }
    }

    public void afterExecute(Task task, TaskState state) {
        if (state.getFailure() != null) {
            this.lastFailed = task;
            this.failed.add(task);
        }
    }

    public void buildFinished(BuildResult result) {
        if (result.getFailure() != null) {
            if (this.failed.isEmpty()) {
                this.announcer.send("Build failed", this.getTaskCountMessage());
            } else {
                this.announcer.send("Build failed", this.getTaskFailureMessage() + "\n" + this.getTaskCountMessage());
            }
        } else {
            this.announcer.send("Build successful", this.getTaskCountMessage());
        }
    }

    private String getTaskFailureCountMessage() {
        if (this.failed.size() == 1) {
            return "1 task failed";
        }
        return this.failed.size() + " tasks failed";
    }

    private String getTaskFailureMessage() {
        if (this.failed.size() == 1) {
            return this.failed.get(0) + " failed";
        }
        return this.failed.size() + " tasks failed";
    }

    private String getTaskCountMessage() {
        if (this.taskCount == 0) {
            return "No tasks executed";
        }
        if (this.taskCount == 1) {
            return "1 task executed";
        }
        return this.taskCount + " tasks executed";
    }
}

