/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.TaskView;
import org.gradle.foundation.common.ObserverLord;
import org.gradle.gradleplugin.foundation.DOM4JSerializer;
import org.gradle.gradleplugin.foundation.ExtensionFileFilter;
import org.gradle.gradleplugin.foundation.filters.BasicProjectAndTaskFilter;
import org.gradle.gradleplugin.foundation.filters.ProjectAndTaskFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFilterEditor
implements ProjectAndTaskFilter {
    private List<String> filteredOutProjectNames = new ArrayList<String>();
    private List<String> filteredOutTaskNames = new ArrayList<String>();
    private boolean filterOutTasksWithNoDescription;
    private ObserverLord<FilterEditorObserver> observerLord = new ObserverLord();

    public BasicFilterEditor() {
    }

    public BasicFilterEditor(BasicProjectAndTaskFilter filter) {
        this.initializeFromFilter(filter);
    }

    public void initializeFromFilter(BasicProjectAndTaskFilter filter) {
        this.filteredOutProjectNames.clear();
        this.hideProjectsByName(filter.getFilteredOutProjectNames());
        this.filteredOutTaskNames.clear();
        this.hideTasksByName(filter.getFilteredOutTaskNames());
        this.filterOutTasksWithNoDescription = filter.filterOutTasksWithNoDescription();
        this.notifyChanges();
    }

    public void addFilterEditorObserver(FilterEditorObserver observer, boolean inEventQueue) {
        this.observerLord.addObserver(observer, inEventQueue);
    }

    public void removeFilterEditorObserver(FilterEditorObserver observer) {
        this.observerLord.removeObserver(observer);
    }

    public boolean filterOutTasksWithNoDescription() {
        return this.filterOutTasksWithNoDescription;
    }

    public void setFilterOutTasksWithNoDescription(boolean filterOutTasksWithNoDescription) {
        this.filterOutTasksWithNoDescription = filterOutTasksWithNoDescription;
    }

    public void hideProjects(ProjectView ... filteredProjects) {
        this.hideProjects(Arrays.asList(filteredProjects));
    }

    public void hideProjects(List<ProjectView> filteredProjects) {
        for (ProjectView projectView : filteredProjects) {
            if (this.filteredOutProjectNames.contains(projectView.getName())) continue;
            this.filteredOutProjectNames.add(projectView.getName());
        }
        this.notifyChanges();
    }

    public void hideProjectsByName(String ... projectNames) {
        this.hideProjectsByName(Arrays.asList(projectNames));
    }

    public void hideProjectsByName(List<String> projectNames) {
        for (String gradleProject : projectNames) {
            if (this.filteredOutProjectNames.contains(gradleProject)) continue;
            this.filteredOutProjectNames.add(gradleProject);
        }
        this.notifyChanges();
    }

    public void showProjects(ProjectView ... filteredProjects) {
        this.showProjects(Arrays.asList(filteredProjects));
    }

    public void showProjects(List<ProjectView> filteredProjects) {
        for (ProjectView projectView : filteredProjects) {
            this.filteredOutProjectNames.remove(projectView.getName());
        }
        this.notifyChanges();
    }

    public void showProjectsByName(String ... filteredProjects) {
        this.showProjectsByName(Arrays.asList(filteredProjects));
    }

    public void showProjectsByName(List<String> filteredProjects) {
        for (String gradleProjectName : filteredProjects) {
            this.filteredOutProjectNames.remove(gradleProjectName);
        }
        this.notifyChanges();
    }

    @Override
    public boolean doesAllowProject(ProjectView project) {
        return !this.filteredOutProjectNames.contains(project.getName());
    }

    public boolean doesAllowProject(String projectName) {
        return !this.filteredOutProjectNames.contains(projectName);
    }

    public void hideTasks(TaskView ... filteredTasks) {
        this.hideTasks(Arrays.asList(filteredTasks));
    }

    public void hideTasks(List<TaskView> filteredTasks) {
        for (TaskView taskView : filteredTasks) {
            if (this.filteredOutTaskNames.contains(taskView.getName())) continue;
            this.filteredOutTaskNames.add(taskView.getName());
        }
        this.notifyChanges();
    }

    public void hideTasksByName(String ... taskNames) {
        this.hideTasksByName(Arrays.asList(taskNames));
    }

    public void hideTasksByName(List<String> taskNames) {
        for (String gradleTask : taskNames) {
            if (this.filteredOutTaskNames.contains(gradleTask)) continue;
            this.filteredOutTaskNames.add(gradleTask);
        }
        this.notifyChanges();
    }

    public void showTasks(TaskView ... filteredTasks) {
        this.showTasks(Arrays.asList(filteredTasks));
    }

    public void showTasks(List<TaskView> filteredTasks) {
        for (TaskView taskView : filteredTasks) {
            this.filteredOutTaskNames.remove(taskView.getName());
        }
        this.notifyChanges();
    }

    public void showTasksByName(String ... filteredTasks) {
        this.showTasksByName(Arrays.asList(filteredTasks));
    }

    public void showTasksByName(List<String> filteredTasks) {
        for (String gradleTaskName : filteredTasks) {
            this.filteredOutTaskNames.remove(gradleTaskName);
        }
        this.notifyChanges();
    }

    @Override
    public boolean doesAllowTask(TaskView task) {
        return BasicProjectAndTaskFilter.doesAllowTask(task, this.filteredOutTaskNames, this.filterOutTasksWithNoDescription);
    }

    public boolean doesAllowTask(String taskName) {
        return !this.filteredOutTaskNames.contains(taskName);
    }

    public BasicProjectAndTaskFilter createFilter() {
        return new BasicProjectAndTaskFilter(this.filteredOutProjectNames, this.filteredOutTaskNames, this.filterOutTasksWithNoDescription);
    }

    public void exportToFile(DOM4JSerializer.ExportInteraction exportInteraction) {
        BasicProjectAndTaskFilter basicProjectAndTaskFilter = this.createFilter();
        DOM4JSerializer.exportToFile("basic-filter", exportInteraction, this.createFileFilter(), basicProjectAndTaskFilter);
    }

    public boolean importFromFile(DOM4JSerializer.ImportInteraction importInteraction) {
        BasicProjectAndTaskFilter basicProjectAndTaskFilter = new BasicProjectAndTaskFilter();
        if (!DOM4JSerializer.importFromFile(importInteraction, this.createFileFilter(), basicProjectAndTaskFilter)) {
            return false;
        }
        this.initializeFromFilter(basicProjectAndTaskFilter);
        this.notifyChanges();
        return true;
    }

    private ExtensionFileFilter createFileFilter() {
        return new ExtensionFileFilter(".task-filter", "Task Filter");
    }

    private void notifyChanges() {
        this.observerLord.notifyObservers(new ObserverLord.ObserverNotification<FilterEditorObserver>(){

            @Override
            public void notify(FilterEditorObserver observer) {
                observer.filterChanged();
            }
        });
    }

    public static interface FilterEditorObserver {
        public void filterChanged();
    }
}

