/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.gradleplugin.foundation.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.gradleplugin.foundation.search.BasicTextSearchCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockSearchEditor {
    private List<SearchResult> matchedResults = new ArrayList<SearchResult>();

    public int searchAllText(String textToSearch, BasicTextSearchCriteria searchCriteria) {
        this.matchedResults.clear();
        if (textToSearch == null) {
            return 0;
        }
        Pattern pattern = searchCriteria.getRegularExpressionPattern();
        if (pattern == null) {
            return 0;
        }
        Matcher matcher = pattern.matcher(textToSearch);
        searchCriteria.resetHasChanged();
        boolean wasMatchFound = false;
        int matcherStart = 0;
        do {
            if (!(wasMatchFound = matcher.find(matcherStart))) continue;
            String matchedText = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            this.matchedResults.add(new SearchResult(matchedText, start, end));
            matcherStart = end + 1;
        } while (wasMatchFound);
        return this.matchedResults.size();
    }

    public List<SearchResult> getMatchedResults() {
        return Collections.unmodifiableList(this.matchedResults);
    }

    public boolean hasMatches() {
        return !this.matchedResults.isEmpty();
    }

    public SearchResult getNextSearchResult(int fromLocation) {
        if (this.matchedResults.isEmpty()) {
            return null;
        }
        for (SearchResult searchResult : this.matchedResults) {
            if (searchResult.getBeginningIndexOfMatch() <= fromLocation) continue;
            return searchResult;
        }
        return this.matchedResults.get(0);
    }

    public SearchResult getPreviousSearchResult(int fromLocation) {
        if (this.matchedResults.isEmpty()) {
            return null;
        }
        for (int index = this.matchedResults.size() - 1; index >= 0; --index) {
            SearchResult searchResult = this.matchedResults.get(index);
            if (searchResult.getEndingIndexOfMatch() >= fromLocation) continue;
            return searchResult;
        }
        return this.matchedResults.get(this.matchedResults.size() - 1);
    }

    public static class SearchResult {
        private String matchedText;
        private int beginningIndexOfMatch;
        private int endingIndexOfMatch;

        public SearchResult(String matchedText, int beginningIndexOfMatch, int endingIndexOfMatch) {
            this.beginningIndexOfMatch = beginningIndexOfMatch;
            this.endingIndexOfMatch = endingIndexOfMatch;
            this.matchedText = matchedText;
        }

        public String getMatchedText() {
            return this.matchedText;
        }

        public int getBeginningIndexOfMatch() {
            return this.beginningIndexOfMatch;
        }

        public int getEndingIndexOfMatch() {
            return this.endingIndexOfMatch;
        }

        public boolean foundAMatch() {
            return this.beginningIndexOfMatch != -1;
        }

        public String toString() {
            if (!this.foundAMatch()) {
                return "No match found";
            }
            return "Matched '" + this.matchedText + "' at " + this.beginningIndexOfMatch + " - " + this.endingIndexOfMatch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchResult that = (SearchResult)o;
            if (this.beginningIndexOfMatch != that.beginningIndexOfMatch) {
                return false;
            }
            if (this.endingIndexOfMatch != that.endingIndexOfMatch) {
                return false;
            }
            return !(this.matchedText != null ? !this.matchedText.equals(that.matchedText) : that.matchedText != null);
        }

        public int hashCode() {
            int result = this.matchedText != null ? this.matchedText.hashCode() : 0;
            result = 31 * result + this.beginningIndexOfMatch;
            result = 31 * result + this.endingIndexOfMatch;
            return result;
        }
    }
}

