/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.events;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.RenderableOutputEvent;
import org.gradle.internal.logging.text.StyledTextOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyledTextOutputEvent
extends RenderableOutputEvent {
    private final List<Span> spans;

    public StyledTextOutputEvent(long timestamp, String category, String text) {
        this(timestamp, category, StyledTextOutput.Style.Normal, text);
    }

    public StyledTextOutputEvent(long timestamp, String category, LogLevel logLevel, String text) {
        this(timestamp, category, logLevel, StyledTextOutput.Style.Normal, text);
    }

    public StyledTextOutputEvent(long timestamp, String category, StyledTextOutput.Style style, String text) {
        this(timestamp, category, null, style, text);
    }

    public StyledTextOutputEvent(long timestamp, String category, LogLevel logLevel, StyledTextOutput.Style style, String text) {
        this(timestamp, category, logLevel, Collections.singletonList(new Span(style, text)));
    }

    public StyledTextOutputEvent(long timestamp, String category, List<Span> spans) {
        this(timestamp, category, null, spans);
    }

    public StyledTextOutputEvent(long timestamp, String category, LogLevel logLevel, Span ... spans) {
        this(timestamp, category, logLevel, Arrays.asList(spans));
    }

    public StyledTextOutputEvent(long timestamp, String category, LogLevel logLevel, List<Span> spans) {
        super(timestamp, category, logLevel);
        this.spans = new ArrayList<Span>(spans);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[').append((Object)this.getLogLevel()).append("] [");
        builder.append(this.getCategory()).append("] ");
        for (Span span : this.spans) {
            builder.append('<');
            builder.append((Object)span.style);
            builder.append(">");
            builder.append(span.text);
            builder.append("</");
            builder.append((Object)span.style);
            builder.append(">");
        }
        return builder.toString();
    }

    public StyledTextOutputEvent withLogLevel(LogLevel logLevel) {
        return new StyledTextOutputEvent(this.getTimestamp(), this.getCategory(), logLevel, this.spans);
    }

    public List<Span> getSpans() {
        return this.spans;
    }

    @Override
    public void render(StyledTextOutput output) {
        for (Span span : this.spans) {
            output.style(span.style);
            output.text(span.text);
        }
    }

    public static class Span
    implements Serializable {
        private final String text;
        private final StyledTextOutput.Style style;

        public Span(StyledTextOutput.Style style, String text) {
            this.style = style;
            this.text = text;
        }

        public Span(String text) {
            this.style = StyledTextOutput.Style.Normal;
            this.text = text;
        }

        public StyledTextOutput.Style getStyle() {
            return this.style;
        }

        public String getText() {
            return this.text;
        }
    }
}

