/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.registry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.launcher.daemon.registry.DaemonStopEvent;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonStopEvents {
    private static final int RECENTLY = 1;

    public static List<DaemonStopEvent> uniqueRecentDaemonStopEvents(List<DaemonStopEvent> stopEvents) {
        HashSet<Long> uniqueStoppedPids = new HashSet<Long>(stopEvents.size());
        ArrayList<DaemonStopEvent> recentStopEvents = new ArrayList<DaemonStopEvent>(stopEvents.size());
        List<DaemonStopEvent> sortedEvents = CollectionUtils.sort(stopEvents, new Comparator<DaemonStopEvent>(){

            @Override
            public int compare(DaemonStopEvent event1, DaemonStopEvent event2) {
                if (event1.getStatus() != null && event2.getStatus() == null) {
                    return -1;
                }
                if (event1.getStatus() == null && event2.getStatus() != null) {
                    return 1;
                }
                if (event1.getStatus() != null && event2.getStatus() != null) {
                    return event2.getStatus().compareTo(event1.getStatus());
                }
                return 0;
            }
        });
        for (DaemonStopEvent event : sortedEvents) {
            Long pid = event.getPid();
            if (!event.occurredInLastHours(1) || uniqueStoppedPids.contains(pid)) continue;
            if (pid != null) {
                uniqueStoppedPids.add(pid);
            }
            recentStopEvents.add(event);
        }
        return recentStopEvents;
    }

    public static List<DaemonStopEvent> oldStopEvents(List<DaemonStopEvent> stopEvents) {
        return CollectionUtils.filter(stopEvents, new Spec<DaemonStopEvent>(){

            @Override
            public boolean isSatisfiedBy(DaemonStopEvent event) {
                return !event.occurredInLastHours(1);
            }
        });
    }
}

