/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeDependencySet;
import org.gradle.nativeplatform.PreprocessingTool;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.toolchain.internal.MacroArgsConverter;

public class VisualStudioProjectConfiguration {
    private final DefaultVisualStudioProject vsProject;
    private final String configurationName;
    private final String platformName;
    private final NativeBinarySpecInternal binary;
    private final String type = "Makefile";

    public VisualStudioProjectConfiguration(DefaultVisualStudioProject vsProject, String configurationName, String platformName, NativeBinarySpec binary) {
        this.vsProject = vsProject;
        this.configurationName = configurationName;
        this.platformName = platformName;
        this.binary = (NativeBinarySpecInternal)binary;
    }

    public String getName() {
        return this.configurationName + "|" + this.platformName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getBuildTask() {
        return this.binary.getTasks().getBuild().getPath();
    }

    public String getCleanTask() {
        return this.taskPath("clean");
    }

    private String taskPath(String taskName) {
        String projectPath = this.binary.getComponent().getProjectPath();
        if (":".equals(projectPath)) {
            return ":" + taskName;
        }
        return projectPath + ":" + taskName;
    }

    public File getOutputFile() {
        return this.binary.getPrimaryOutput();
    }

    public boolean isDebug() {
        return !"release".equals(this.binary.getBuildType().getName());
    }

    public List<String> getCompilerDefines() {
        ArrayList<String> defines = new ArrayList<String>();
        defines.addAll(this.getDefines("cCompiler"));
        defines.addAll(this.getDefines("cppCompiler"));
        defines.addAll(this.getDefines("rcCompiler"));
        return defines;
    }

    private List<String> getDefines(String tool) {
        PreprocessingTool rcCompiler = this.findCompiler(tool);
        return rcCompiler == null ? new ArrayList<String>() : new MacroArgsConverter().transform(rcCompiler.getMacros());
    }

    private PreprocessingTool findCompiler(String tool) {
        return (PreprocessingTool)this.binary.getToolByName(tool);
    }

    public List<File> getIncludePaths() {
        LinkedHashSet includes = new LinkedHashSet();
        for (LanguageSourceSet sourceSet : this.binary.getInputs()) {
            if (!(sourceSet instanceof HeaderExportingSourceSet)) continue;
            includes.addAll(((HeaderExportingSourceSet)sourceSet).getExportedHeaders().getSrcDirs());
        }
        for (NativeDependencySet lib : this.binary.getLibs()) {
            includes.addAll(lib.getIncludeRoots().getFiles());
        }
        return new ArrayList<File>(includes);
    }

    public DefaultVisualStudioProject getProject() {
        return this.vsProject;
    }

    public final NativeBinarySpecInternal getBinary() {
        return this.binary;
    }

    public final String getType() {
        return "Makefile";
    }
}

