/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameComparator
implements Comparator<String> {
    @Override
    public int compare(String taskName1, String taskName2) {
        int depthDiff = this.getDepth(taskName1) - this.getDepth(taskName2);
        if (depthDiff != 0) {
            return depthDiff;
        }
        return this.compareSegments(taskName1, taskName2);
    }

    private int compareSegments(String taskName1, String taskName2) {
        int diff;
        int colon1 = taskName1.indexOf(58);
        int colon2 = taskName2.indexOf(58);
        if (colon1 > 0 && colon2 > 0 && (diff = taskName1.substring(0, colon1).compareTo(taskName2.substring(0, colon2))) != 0) {
            return diff;
        }
        return colon1 == -1 ? taskName1.compareTo(taskName2) : this.compareSegments(taskName1.substring(colon1 + 1), taskName2.substring(colon2 + 1));
    }

    private int getDepth(String taskName) {
        int counter = 0;
        for (char c : taskName.toCharArray()) {
            if (c != ':') continue;
            ++counter;
        }
        return counter;
    }
}

