/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.springframework.boot.loader.tools.JarWriter;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.Layouts;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.boot.loader.tools.RepackagingLayout;
import org.springframework.lang.UsesJava8;

public class Repackager {
    private static final String MAIN_CLASS_ATTRIBUTE = "Main-Class";
    private static final String START_CLASS_ATTRIBUTE = "Start-Class";
    private static final String BOOT_VERSION_ATTRIBUTE = "Spring-Boot-Version";
    private static final String BOOT_LIB_ATTRIBUTE = "Spring-Boot-Lib";
    private static final String BOOT_CLASSES_ATTRIBUTE = "Spring-Boot-Classes";
    private static final byte[] ZIP_FILE_HEADER = new byte[]{80, 75, 3, 4};
    private String mainClass;
    private boolean backupSource = true;
    private final File source;
    private Layout layout;

    public Repackager(File source) {
        if (source == null || !source.exists() || !source.isFile()) {
            throw new IllegalArgumentException("Source must refer to an existing file");
        }
        this.source = source.getAbsoluteFile();
        this.layout = Layouts.forFile(source);
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public void setBackupSource(boolean backupSource) {
        this.backupSource = backupSource;
    }

    public void setLayout(Layout layout) {
        if (layout == null) {
            throw new IllegalArgumentException("Layout must not be null");
        }
        this.layout = layout;
    }

    public void repackage(Libraries libraries) throws IOException {
        this.repackage(this.source, libraries);
    }

    public void repackage(File destination, Libraries libraries) throws IOException {
        this.repackage(destination, libraries, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repackage(File destination, Libraries libraries, LaunchScript launchScript) throws IOException {
        if (destination == null || destination.isDirectory()) {
            throw new IllegalArgumentException("Invalid destination");
        }
        if (libraries == null) {
            throw new IllegalArgumentException("Libraries must not be null");
        }
        if (this.alreadyRepackaged()) {
            return;
        }
        destination = destination.getAbsoluteFile();
        File workingSource = this.source;
        if (this.source.equals(destination)) {
            workingSource = this.getBackupFile();
            workingSource.delete();
            this.renameFile(this.source, workingSource);
        }
        destination.delete();
        try {
            JarFile jarFileSource = new JarFile(workingSource);
            try {
                this.repackage(jarFileSource, destination, libraries, launchScript);
            }
            finally {
                jarFileSource.close();
            }
        }
        finally {
            if (!this.backupSource && !this.source.equals(workingSource)) {
                this.deleteFile(workingSource);
            }
        }
    }

    public final File getBackupFile() {
        return new File(this.source.getParentFile(), this.source.getName() + ".original");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean alreadyRepackaged() throws IOException {
        JarFile jarFile = new JarFile(this.source);
        try {
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest != null && manifest.getMainAttributes().getValue(BOOT_VERSION_ATTRIBUTE) != null;
            return bl;
        }
        finally {
            jarFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repackage(JarFile sourceJar, File destination, Libraries libraries, LaunchScript launchScript) throws IOException {
        JarWriter writer = new JarWriter(destination, launchScript);
        try {
            final ArrayList<Library> unpackLibraries = new ArrayList<Library>();
            final ArrayList<Library> standardLibraries = new ArrayList<Library>();
            libraries.doWithLibraries(new LibraryCallback(){

                @Override
                public void library(Library library) throws IOException {
                    File file = library.getFile();
                    if (Repackager.this.isZip(file)) {
                        if (library.isUnpackRequired()) {
                            unpackLibraries.add(library);
                        } else {
                            standardLibraries.add(library);
                        }
                    }
                }
            });
            writer.writeManifest(this.buildManifest(sourceJar));
            HashSet<String> seen = new HashSet<String>();
            this.writeNestedLibraries(unpackLibraries, seen, writer);
            if (this.layout instanceof RepackagingLayout) {
                writer.writeEntries(sourceJar, new RenamingEntryTransformer(((RepackagingLayout)this.layout).getRepackagedClassesLocation()));
            } else {
                writer.writeEntries(sourceJar);
            }
            this.writeNestedLibraries(standardLibraries, seen, writer);
            if (this.layout.isExecutable()) {
                writer.writeLoaderClasses();
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void writeNestedLibraries(List<Library> libraries, Set<String> alreadySeen, JarWriter writer) throws IOException {
        for (Library library : libraries) {
            String destination = this.layout.getLibraryDestination(library.getName(), library.getScope());
            if (destination == null) continue;
            if (!alreadySeen.add(destination + library.getName())) {
                throw new IllegalStateException("Duplicate library " + library.getName());
            }
            writer.writeNestedLibrary(destination, library);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isZip(File file) {
        boolean bl;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            bl = this.isZip(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException ex) {
                return false;
            }
        }
        fileInputStream.close();
        return bl;
    }

    private boolean isZip(InputStream inputStream) throws IOException {
        for (int i = 0; i < ZIP_FILE_HEADER.length; ++i) {
            if (inputStream.read() == ZIP_FILE_HEADER[i]) continue;
            return false;
        }
        return true;
    }

    private Manifest buildManifest(JarFile source) throws IOException {
        String launcherClassName;
        Manifest manifest = source.getManifest();
        if (manifest == null) {
            manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
        }
        manifest = new Manifest(manifest);
        String startClass = this.mainClass;
        if (startClass == null) {
            startClass = manifest.getMainAttributes().getValue(MAIN_CLASS_ATTRIBUTE);
        }
        if (startClass == null) {
            startClass = this.findMainMethod(source);
        }
        if ((launcherClassName = this.layout.getLauncherClassName()) != null) {
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, launcherClassName);
            if (startClass == null) {
                throw new IllegalStateException("Unable to find main class");
            }
            manifest.getMainAttributes().putValue(START_CLASS_ATTRIBUTE, startClass);
        } else if (startClass != null) {
            manifest.getMainAttributes().putValue(MAIN_CLASS_ATTRIBUTE, startClass);
        }
        String bootVersion = this.getClass().getPackage().getImplementationVersion();
        manifest.getMainAttributes().putValue(BOOT_VERSION_ATTRIBUTE, bootVersion);
        manifest.getMainAttributes().putValue(BOOT_CLASSES_ATTRIBUTE, this.layout instanceof RepackagingLayout ? ((RepackagingLayout)this.layout).getRepackagedClassesLocation() : this.layout.getClassesLocation());
        manifest.getMainAttributes().putValue(BOOT_LIB_ATTRIBUTE, this.layout.getLibraryDestination("", LibraryScope.COMPILE));
        return manifest;
    }

    protected String findMainMethod(JarFile source) throws IOException {
        return MainClassFinder.findSingleMainClass(source, this.layout.getClassesLocation());
    }

    private void renameFile(File file, File dest) {
        if (!file.renameTo(dest)) {
            throw new IllegalStateException("Unable to rename '" + file + "' to '" + dest + "'");
        }
    }

    private void deleteFile(File file) {
        if (!file.delete()) {
            throw new IllegalStateException("Unable to delete '" + file + "'");
        }
    }

    private static final class RenamingEntryTransformer
    implements JarWriter.EntryTransformer {
        private final String namePrefix;

        private RenamingEntryTransformer(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public JarEntry transform(JarEntry entry) {
            if (entry.getName().equals("META-INF/INDEX.LIST")) {
                return null;
            }
            if (entry.getName().startsWith("META-INF/") || entry.getName().startsWith("BOOT-INF/")) {
                return entry;
            }
            JarEntry renamedEntry = new JarEntry(this.namePrefix + entry.getName());
            renamedEntry.setTime(entry.getTime());
            renamedEntry.setSize(entry.getSize());
            renamedEntry.setMethod(entry.getMethod());
            if (entry.getComment() != null) {
                renamedEntry.setComment(entry.getComment());
            }
            renamedEntry.setCompressedSize(entry.getCompressedSize());
            renamedEntry.setCrc(entry.getCrc());
            this.setCreationTimeIfPossible(entry, renamedEntry);
            if (entry.getExtra() != null) {
                renamedEntry.setExtra(entry.getExtra());
            }
            this.setLastAccessTimeIfPossible(entry, renamedEntry);
            this.setLastModifiedTimeIfPossible(entry, renamedEntry);
            return renamedEntry;
        }

        @UsesJava8
        private void setCreationTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getCreationTime() != null) {
                    target.setCreationTime(source.getCreationTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        @UsesJava8
        private void setLastAccessTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getLastAccessTime() != null) {
                    target.setLastAccessTime(source.getLastAccessTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        @UsesJava8
        private void setLastModifiedTimeIfPossible(JarEntry source, JarEntry target) {
            try {
                if (source.getLastModifiedTime() != null) {
                    target.setLastModifiedTime(source.getLastModifiedTime());
                }
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }
}

