/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.xml;

import groovy.xml.streamingmarkupsupport.StreamingMarkupWriter;
import java.io.IOException;
import java.io.Writer;
import org.grails.web.xml.XMLStreamWriter;

public class PrettyPrintXMLStreamWriter
extends XMLStreamWriter {
    public static final String DEFAULT_INDENT_STR = "  ";
    public static final String NEWLINE;
    private final String indent;
    private int level = 0;
    private boolean doIndent = false;

    public PrettyPrintXMLStreamWriter(StreamingMarkupWriter writer) {
        this(writer, DEFAULT_INDENT_STR);
    }

    public PrettyPrintXMLStreamWriter(StreamingMarkupWriter writer, String indent) {
        super(writer);
        this.indent = indent;
    }

    private void newline() throws IOException {
        this.writer.unescaped().write(NEWLINE);
    }

    private void indent() throws IOException {
        Writer ue = this.writer.unescaped();
        for (int i = 0; i < this.level; ++i) {
            ue.write(this.indent);
        }
    }

    @Override
    protected void endStartTag() throws IOException {
        super.endStartTag();
        this.newline();
        if (this.doIndent) {
            this.indent();
        }
    }

    @Override
    protected void startTag() throws IOException {
        this.indent();
        super.startTag();
    }

    @Override
    public XMLStreamWriter startNode(String tag) throws IOException {
        this.doIndent = false;
        super.startNode(tag);
        ++this.level;
        return this;
    }

    @Override
    public XMLStreamWriter end() throws IOException {
        --this.level;
        if (this.mode != XMLStreamWriter.Mode.TAG) {
            this.indent();
        }
        super.end();
        this.newline();
        return this;
    }

    @Override
    public XMLStreamWriter characters(String data) throws IOException {
        this.doIndent = true;
        super.characters(data);
        this.newline();
        return this;
    }

    @Override
    public XMLStreamWriter startDocument(String encoding, String version) throws IOException {
        super.startDocument(encoding, version);
        this.newline();
        return this;
    }

    static {
        String nl = System.getProperty("line.separator");
        NEWLINE = nl != null ? nl : "\n";
    }
}

