/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.aopalliance.aop.Advice;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.Assert;

public abstract class AbstractBeanFactoryPointcutAdvisor
extends AbstractPointcutAdvisor
implements BeanFactoryAware {
    private String adviceBeanName;
    private BeanFactory beanFactory;
    private volatile transient Advice advice;
    private volatile transient Object adviceMonitor = new Object();

    public void setAdviceBeanName(String adviceBeanName) {
        this.adviceBeanName = adviceBeanName;
    }

    public String getAdviceBeanName() {
        return this.adviceBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.resetAdviceMonitor();
    }

    private void resetAdviceMonitor() {
        this.adviceMonitor = this.beanFactory instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)this.beanFactory).getSingletonMutex() : new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAdvice(Advice advice) {
        Object object = this.adviceMonitor;
        synchronized (object) {
            this.advice = advice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Advice getAdvice() {
        Advice advice = this.advice;
        if (advice != null || this.adviceBeanName == null) {
            return advice;
        }
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to resolve 'adviceBeanName'");
        if (this.beanFactory.isSingleton(this.adviceBeanName)) {
            this.advice = advice = (Advice)this.beanFactory.getBean(this.adviceBeanName, Advice.class);
            return advice;
        }
        Object object = this.adviceMonitor;
        synchronized (object) {
            if (this.advice == null) {
                this.advice = (Advice)this.beanFactory.getBean(this.adviceBeanName, Advice.class);
            }
            return this.advice;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(": advice ");
        if (this.adviceBeanName != null) {
            sb.append("bean '").append(this.adviceBeanName).append("'");
        } else {
            sb.append(this.advice);
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.resetAdviceMonitor();
    }
}

