/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class ANTLR
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private File targetFile;
    private File outputDirectory;
    private File superGrammar;
    private boolean html;
    private boolean diagnostic;
    private boolean trace;
    private boolean traceParser;
    private boolean traceLexer;
    private boolean traceTreeWalker;
    private File workingdir = null;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private boolean debug;
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    public ANTLR() {
        this.commandline.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.commandline.setClassname("antlr.Tool");
    }

    public void setTarget(File target) {
        this.log("Setting target to: " + target.toString(), 3);
        this.targetFile = target;
    }

    public void setOutputdirectory(File outputDirectory) {
        this.log("Setting output directory to: " + outputDirectory.toString(), 3);
        this.outputDirectory = outputDirectory;
    }

    public void setGlib(String superGrammar) {
        String sg = null;
        sg = Os.isFamily((String)"dos") ? superGrammar.replace('\\', '/') : superGrammar;
        this.setGlib(FILE_UTILS.resolveFile(this.getProject().getBaseDir(), sg));
    }

    public void setGlib(File superGrammar) {
        this.superGrammar = superGrammar;
    }

    public void setDebug(boolean enable) {
        this.debug = enable;
    }

    public void setHtml(boolean enable) {
        this.html = enable;
    }

    public void setDiagnostic(boolean enable) {
        this.diagnostic = enable;
    }

    public void setTrace(boolean enable) {
        this.trace = enable;
    }

    public void setTraceParser(boolean enable) {
        this.traceParser = enable;
    }

    public void setTraceLexer(boolean enable) {
        this.traceLexer = enable;
    }

    public void setTraceTreeWalker(boolean enable) {
        this.traceTreeWalker = enable;
    }

    public void setFork(boolean s) {
    }

    public void setDir(File d) {
        this.workingdir = d;
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.getProject()).createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void init() throws BuildException {
        this.addClasspathEntry("/antlr/ANTLRGrammarParseBehavior.class");
    }

    protected void addClasspathEntry(String resource) {
        resource = resource.startsWith("/") ? resource.substring(1) : "org/apache/tools/ant/taskdefs/optional/" + resource;
        File f = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resource);
        if (f != null) {
            this.log("Found " + f.getAbsolutePath(), 4);
            this.createClasspath().setLocation(f);
        } else {
            this.log("Couldn't find " + resource, 3);
        }
    }

    public void execute() throws BuildException {
        boolean superGrammarIsOutOfDate;
        this.validateAttributes();
        File generatedFile = this.getGeneratedFile();
        boolean targetIsOutOfDate = this.targetFile.lastModified() > generatedFile.lastModified();
        boolean bl = superGrammarIsOutOfDate = this.superGrammar != null && this.superGrammar.lastModified() > generatedFile.lastModified();
        if (targetIsOutOfDate || superGrammarIsOutOfDate) {
            if (targetIsOutOfDate) {
                this.log("Compiling " + this.targetFile + " as it is newer than " + generatedFile, 3);
            } else {
                this.log("Compiling " + this.targetFile + " as " + this.superGrammar + " is newer than " + generatedFile, 3);
            }
            this.populateAttributes();
            this.commandline.createArgument().setValue(this.targetFile.toString());
            this.log(this.commandline.describeCommand(), 3);
            int err = this.run(this.commandline.getCommandline());
            if (err != 0) {
                throw new BuildException("ANTLR returned: " + err, this.getLocation());
            }
            String output = this.bos.toString();
            if (output.indexOf("error:") > -1) {
                throw new BuildException("ANTLR signaled an error: " + output, this.getLocation());
            }
        } else {
            this.log("Skipped grammar file. Generated file " + generatedFile + " is newer.", 3);
        }
    }

    private void populateAttributes() {
        this.commandline.createArgument().setValue("-o");
        this.commandline.createArgument().setValue(this.outputDirectory.toString());
        if (this.superGrammar != null) {
            this.commandline.createArgument().setValue("-glib");
            this.commandline.createArgument().setValue(this.superGrammar.toString());
        }
        if (this.html) {
            this.commandline.createArgument().setValue("-html");
        }
        if (this.diagnostic) {
            this.commandline.createArgument().setValue("-diagnostic");
        }
        if (this.trace) {
            this.commandline.createArgument().setValue("-trace");
        }
        if (this.traceParser) {
            this.commandline.createArgument().setValue("-traceParser");
        }
        if (this.traceLexer) {
            this.commandline.createArgument().setValue("-traceLexer");
        }
        if (this.traceTreeWalker) {
            if (this.is272()) {
                this.commandline.createArgument().setValue("-traceTreeParser");
            } else {
                this.commandline.createArgument().setValue("-traceTreeWalker");
            }
        }
        if (this.debug) {
            this.commandline.createArgument().setValue("-debug");
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.targetFile == null || !this.targetFile.isFile()) {
            throw new BuildException("Invalid target: " + this.targetFile);
        }
        if (this.outputDirectory == null) {
            this.setOutputdirectory(new File(this.targetFile.getParent()));
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Invalid output directory: " + this.outputDirectory);
        }
    }

    private File getGeneratedFile() throws BuildException {
        String generatedFileName = null;
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(this.targetFile));
            while ((line = in.readLine()) != null) {
                int extendsIndex = line.indexOf(" extends ");
                if (!line.startsWith("class ") || extendsIndex <= -1) continue;
                generatedFileName = line.substring("class ".length(), extendsIndex).trim();
                break;
            }
            in.close();
        }
        catch (Exception e) {
            throw new BuildException("Unable to determine generated class", (Throwable)e);
        }
        if (generatedFileName == null) {
            throw new BuildException("Unable to determine generated class");
        }
        return new File(this.outputDirectory, generatedFileName + (this.html ? ".html" : ".java"));
    }

    private int run(String[] command) throws BuildException {
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)new LogOutputStream((Task)this, 2), (OutputStream)new TeeOutputStream((OutputStream)new LogOutputStream((Task)this, 1), (OutputStream)this.bos));
        Execute exe = new Execute((ExecuteStreamHandler)psh, null);
        exe.setAntRun(this.getProject());
        if (this.workingdir != null) {
            exe.setWorkingDirectory(this.workingdir);
        }
        exe.setCommandline(command);
        try {
            int n = exe.execute();
            return n;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.getLocation());
        }
        finally {
            FileUtils.close((OutputStream)this.bos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean is272() {
        AntClassLoader l = null;
        try {
            l = this.getProject().createClassLoader(this.commandline.getClasspath());
            l.loadClass("antlr.Version");
            boolean bl = true;
            return bl;
        }
        catch (ClassNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (l != null) {
                l.cleanup();
            }
        }
    }
}

