// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_DISCOVERERINFO_H
#define _GSTREAMERMM_DISCOVERERINFO_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2011 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/miniobject.h>
#include <gstreamermm/clock.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstDiscovererInfo GstDiscovererInfo;
typedef GObjectClass GstDiscovererInfoClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstDiscovererStreamInfo GstDiscovererStreamInfo;
typedef GObjectClass GstDiscovererStreamInfoClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstDiscovererContainerInfo GstDiscovererContainerInfo;
typedef GObjectClass GstDiscovererContainerInfoClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstDiscovererAudioInfo GstDiscovererAudioInfo;
typedef GObjectClass GstDiscovererAudioInfoClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstDiscovererVideoInfo GstDiscovererVideoInfo;
typedef GObjectClass GstDiscovererVideoInfoClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var DiscovererResult DISCOVERER_OK
 *  The discovery was successful.
 * 
 *  @var DiscovererResult DISCOVERER_URI_INVALID
 *  The URI is invalid.
 * 
 *  @var DiscovererResult DISCOVERER_ERROR
 *  An error happened and the GError is set.
 * 
 *  @var DiscovererResult DISCOVERER_TIMEOUT
 *  The discovery timed-out.
 * 
 *  @var DiscovererResult DISCOVERER_BUSY
 *  The discoverer was already discovering a file.
 * 
 *  @var DiscovererResult DISCOVERER_MISSING_PLUGINS
 *  Some plugins are missing for full discovery.
 * 
 *  @enum DiscovererResult
 * 
 * Result values for the discovery process.
 * @ingroup gstreamermmEnums
 */
enum DiscovererResult
{
  DISCOVERER_OK,
  DISCOVERER_URI_INVALID,
  DISCOVERER_ERROR,
  DISCOVERER_TIMEOUT,
  DISCOVERER_BUSY,
  DISCOVERER_MISSING_PLUGINS
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::DiscovererResult> : public Glib::Value_Enum<Gst::DiscovererResult>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


class Caps;
class DiscovererStreamInfo;
class Structure;
class TagList;

/** DiscovererInfo - Class containing the information of a URI analyzed by
 * Gst::Discoverer.
 */
class DiscovererInfo : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DiscovererInfo CppObjectType;
  typedef GstDiscovererInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  static Glib::RefPtr<DiscovererInfo> create();

  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstDiscovererInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GstDiscovererInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstDiscovererInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gst::DiscovererInfo can neither be constructed nor deleted.
  DiscovererInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  DiscovererInfo(const DiscovererInfo&);
  DiscovererInfo& operator=(const DiscovererInfo&);


  //gtkmmproc error: gst_discoverer_info_ref : ignored method defs lookup failed//gtkmmproc error: gst_discoverer_info_unref : ignored method defs lookup failed
  

public:
  
  /** 
   * 
   * @return The duration of the URI in Gst::ClockTime (nanoseconds).
   */
  ClockTime get_duration() const; 
 

  /** 
   * 
   * @return Miscellaneous information stored as a Gst::Structure
   * (for example: information about missing plugins). If you wish to use the
   * Gst::Structure after the life-time of @a info, you will need to copy it.
   */
  Structure get_misc() const; 
  
  /** 
   * 
   * @return The result of the discovery as a Gst::DiscovererResult.
   */
  DiscovererResult get_result() const; 

  
  /** 
   * 
   * @return The structure (or topology) of the URI as a
   * Gst::DiscovererStreamInfo.
   * This structure can be traversed to see the original hierarchy. Unref with
   * gst_discoverer_stream_info_unref() after usage.
   */
  Glib::RefPtr<DiscovererStreamInfo> get_stream_info(); 
  
  /** 
   * 
   * @return The structure (or topology) of the URI as a
   * Gst::DiscovererStreamInfo.
   * This structure can be traversed to see the original hierarchy. Unref with
   * gst_discoverer_stream_info_unref() after usage.
   */
  Glib::RefPtr<const DiscovererStreamInfo> get_stream_info() const; 

 
  /** 
   * 
   * @return The list of
   * all streams contained in the #info. Free after usage
   * with stream_info_list_free().
   */
  std::vector< Glib::RefPtr<DiscovererStreamInfo> > get_stream_list(); 
  
  /** 
   * 
   * @return The list of
   * all streams contained in the #info. Free after usage
   * with stream_info_list_free().
   */
  std::vector< Glib::RefPtr<const DiscovererStreamInfo> > get_stream_list() const; 

 
  /** 
   * 
   * @return All tags contained in the URI. If you wish to use
   * the tags after the life-time of @a info, you will need to copy them.
   */
  TagList get_tags() const; 

  
  /** 
   * 
   * @return The URI to which this information corresponds to.
   * Copy it if you wish to use it after the life-time of @a info.
   */
  Glib::ustring get_uri() const; 
  
  /** 
   * 
   * @return The whether the URI is seekable.
   */
  bool get_seekable() const; 

  
  /** Finds all the Gst::DiscovererAudioInfo contained in @a info
   * 
   * @return A List of
   * matching Gst::DiscovererStreamInfo. The caller should free it with
   * stream_info_list_free().
   */
  std::vector< Glib::RefPtr<DiscovererStreamInfo> > get_audio_streams(); 
  
  /** Finds all the Gst::DiscovererAudioInfo contained in @a info
   * 
   * @return A List of
   * matching Gst::DiscovererStreamInfo. The caller should free it with
   * stream_info_list_free().
   */
  std::vector< Glib::RefPtr<const DiscovererStreamInfo> > get_audio_streams() const; 

  
  /** Finds all the Gst::DiscovererContainerInfo contained in @a info
   * 
   * @return A List of
   * matching Gst::DiscovererStreamInfo. The caller should free it with
   * stream_info_list_free().
   */
  std::vector< Glib::RefPtr<DiscovererStreamInfo> > get_container_streams(); 
  
  /** Finds all the Gst::DiscovererContainerInfo contained in @a info
   * 
   * @return A List of
   * matching Gst::DiscovererStreamInfo. The caller should free it with
   * stream_info_list_free().
   */
  std::vector< Glib::RefPtr<const DiscovererStreamInfo> > get_container_streams() const; 

  
  /** Finds the Gst::DiscovererStreamInfo contained in @a info that match the
   * given @a streamtype.
   * 
   * @param streamtype A Type derived from Gst::DiscovererStreamInfo.
   * @return A List of
   * matching Gst::DiscovererStreamInfo. The caller should free it with
   * stream_info_list_free().
   */
  std::vector< Glib::RefPtr<DiscovererStreamInfo> > get_streams(GType streamtype); 
  
  /** Finds the Gst::DiscovererStreamInfo contained in @a info that match the
   * given @a streamtype.
   * 
   * @param streamtype A Type derived from Gst::DiscovererStreamInfo.
   * @return A List of
   * matching Gst::DiscovererStreamInfo. The caller should free it with
   * stream_info_list_free().
   */
  std::vector< Glib::RefPtr<const DiscovererStreamInfo> > get_streams(GType streamtype) const; 

  
  /** Finds all the Gst::DiscovererVideoInfo contained in @a info
   * 
   * @return A List of
   * matching Gst::DiscovererStreamInfo. The caller should free it with
   * stream_info_list_free().
   */
  std::vector< Glib::RefPtr<DiscovererStreamInfo> > get_video_streams();
  
  /** Finds all the Gst::DiscovererVideoInfo contained in @a info
   * 
   * @return A List of
   * matching Gst::DiscovererStreamInfo. The caller should free it with
   * stream_info_list_free().
   */
  std::vector< Glib::RefPtr<const DiscovererStreamInfo> > get_video_streams() const;


};

/** DiscovererStreamInfo - Base class for information concerning a media
 * stream.
 * Depending on the stream type, one can find more media-specific information
 * in Gst::DiscovererAudioInfo, Gst::DiscovererVideoInfo, and
 * Gst::DiscovererContainerInfo.
 *
 * The Gst::DiscovererStreamInfo represents the topology of the stream.
 * Siblings can be iterated over with get_next() and get_previous(). Children
 * (sub-streams) of a stream can be accessed using the
 * Gst::DiscovererContainerInfo API.
 *
 * As a simple example, if you run Gst::Discoverer on an AVI file with one
 * audio and one video stream, you will get a Gst::DiscovererContainerInfo
 * corresponding to the AVI container, which in turn will have a
 * Gst::DiscovererAudioInfo sub-stream and a Gst::DiscovererVideoInfo
 * sub-stream for the audio and video streams respectively.
 */
class DiscovererStreamInfo : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DiscovererStreamInfo CppObjectType;
  typedef GstDiscovererStreamInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstDiscovererStreamInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GstDiscovererStreamInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstDiscovererStreamInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gst::DiscovererStreamInfo can neither be constructed nor deleted.
  DiscovererStreamInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  DiscovererStreamInfo(const DiscovererStreamInfo&);
  DiscovererStreamInfo& operator=(const DiscovererStreamInfo&);


  //gtkmmproc error: gst_discoverer_stream_info_ref : ignored method defs lookup failed//gtkmmproc error: gst_discoverer_stream_info_unref : ignored method defs lookup failed
  

public:
  
  /** 
   * 
   * @return The Gst::Caps of the stream. Unref with
   * #gst_caps_unref after usage.
   */
  Glib::RefPtr<Gst::Caps> get_caps();
  
  /** 
   * 
   * @return The Gst::Caps of the stream. Unref with
   * #gst_caps_unref after usage.
   */
  Glib::RefPtr<const Gst::Caps> get_caps() const;

  
  /** 
   * 
   * @return Additional information regarding the stream (for
   * example codec version, profile, etc..). If you wish to use the Gst::Structure
   * after the life-time of @a info you will need to copy it.
   */
  Structure get_misc() const;

  
  /** 
   * 
   * @return The next Gst::DiscovererStreamInfo in a chain. <tt>0</tt>
   * for final streams.
   * Unref with #gst_discoverer_stream_info_unref after usage.
   */
  Glib::RefPtr<DiscovererStreamInfo> get_next();
  
  /** 
   * 
   * @return The next Gst::DiscovererStreamInfo in a chain. <tt>0</tt>
   * for final streams.
   * Unref with #gst_discoverer_stream_info_unref after usage.
   */
  Glib::RefPtr<const DiscovererStreamInfo> get_next() const;

  
  /** 
   * 
   * @return The previous Gst::DiscovererStreamInfo in a chain.
   * <tt>0</tt> for starting points. Unref with #gst_discoverer_stream_info_unref
   * after usage.
   */
  Glib::RefPtr<DiscovererStreamInfo> get_previous();
  
  /** 
   * 
   * @return The previous Gst::DiscovererStreamInfo in a chain.
   * <tt>0</tt> for starting points. Unref with #gst_discoverer_stream_info_unref
   * after usage.
   */
  Glib::RefPtr<DiscovererStreamInfo> get_previous() const;

  
  /** 
   * 
   * @return The tags contained in this stream. If you wish to
   * use the tags after the life-time of @a info you will need to copy them.
   */
  TagList get_tags() const;

  
  /** 
   * 
   * @return A human readable name for the stream type of the given @a info (ex : "audio",
   * "container",...).
   */
  Glib::ustring get_stream_type_nick() const;


};

/** DiscovererContainerInfo - Gst::DiscovererStreamInfo specific to container
 * streams. 
 */
class DiscovererContainerInfo : public DiscovererStreamInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DiscovererContainerInfo CppObjectType;
  typedef GstDiscovererContainerInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstDiscovererContainerInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GstDiscovererContainerInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstDiscovererContainerInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gst::DiscovererContainerInfo can neither be constructed nor deleted.
  DiscovererContainerInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  DiscovererContainerInfo(const DiscovererContainerInfo&);
  DiscovererContainerInfo& operator=(const DiscovererContainerInfo&);


public:
  
  /** 
   * 
   * @return The list of
   * Gst::DiscovererStreamInfo this container stream offers.
   * Free with stream_info_list_free() after usage.
   */
  std::vector< Glib::RefPtr<DiscovererStreamInfo> > get_streams();
  
  /** 
   * 
   * @return The list of
   * Gst::DiscovererStreamInfo this container stream offers.
   * Free with stream_info_list_free() after usage.
   */
  std::vector< Glib::RefPtr<const DiscovererStreamInfo> > get_streams() const;


};


/** DiscovererAudioInfo - Gst::DiscovererStreamInfo specific to audio streams. 
 */
class DiscovererAudioInfo : public DiscovererStreamInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DiscovererAudioInfo CppObjectType;
  typedef GstDiscovererAudioInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstDiscovererAudioInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GstDiscovererAudioInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstDiscovererAudioInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gst::DiscovererAudioInfo can neither be constructed nor deleted.
  DiscovererAudioInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  DiscovererAudioInfo(const DiscovererAudioInfo&);
  DiscovererAudioInfo& operator=(const DiscovererAudioInfo&);


public:
  
  /** 
   * 
   * @return The average or nominal bitrate of the stream in bits/second.
   */
  guint get_bitrate() const;
  
  /** 
   * 
   * @return The number of channels in the stream.
   */
  guint get_channels() const;
  
  /** 
   * 
   * @return The number of bits used per sample in each channel.
   */
  guint get_depth() const;
  
  /** 
   * 
   * @return The maximum bitrate of the stream in bits/second.
   */
  guint get_max_bitrate() const;
  
  /** 
   * 
   * @return The sample rate of the stream in Hertz.
   */
  guint get_sample_rate() const;


};

/** DiscovererVideoInfo - Gst::DiscovererStreamInfo specific to video streams
 * (this includes images). 
 */
class DiscovererVideoInfo : public DiscovererStreamInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DiscovererVideoInfo CppObjectType;
  typedef GstDiscovererVideoInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstDiscovererVideoInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GstDiscovererVideoInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstDiscovererVideoInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gst::DiscovererVideoInfo can neither be constructed nor deleted.
  DiscovererVideoInfo();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  DiscovererVideoInfo(const DiscovererVideoInfo&);
  DiscovererVideoInfo& operator=(const DiscovererVideoInfo&);


public:
  
  /** 
   * 
   * @return The average or nominal bitrate of the video stream in bits/second.
   */
  guint get_bitrate() const;
  
  /** 
   * 
   * @return The depth in bits of the video stream.
   */
  guint get_depth() const;
  
  /** 
   * 
   * @return The framerate of the video stream (denominator).
   */
  guint get_framerate_denom() const;
  
  /** 
   * 
   * @return The framerate of the video stream (numerator).
   */
  guint get_framerate_num() const;
  
  /** 
   * 
   * @return The height of the video stream in pixels.
   */
  guint get_height() const;
  
  /** 
   * 
   * @return <tt>true</tt> if the stream is interlaced, else <tt>false</tt>.
   */
  bool is_interlaced() const;
  
  /** 
   * 
   * @return #<tt>true</tt> if the video stream corresponds to an image (i.e.\ only contains
   * one frame).
   */
  bool is_image() const;
  
  /** 
   * 
   * @return The maximum bitrate of the video stream in bits/second.
   */
  guint get_max_bitrate() const;
  
  /** 
   * 
   * @return The Pixel Aspect Ratio (PAR) of the video stream (denominator).
   */
  guint get_par_denom() const;
  
  /** 
   * 
   * @return The Pixel Aspect Ratio (PAR) of the video stream (numerator).
   */
  guint get_par_num() const;
  
  /** 
   * 
   * @return The width of the video stream in pixels.
   */
  guint get_width() const;


};

} //namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::DiscovererInfo
   */
  Glib::RefPtr<Gst::DiscovererInfo> wrap(GstDiscovererInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::DiscovererStreamInfo
   */
  Glib::RefPtr<Gst::DiscovererStreamInfo> wrap(GstDiscovererStreamInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::DiscovererContainerInfo
   */
  Glib::RefPtr<Gst::DiscovererContainerInfo> wrap(GstDiscovererContainerInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::DiscovererAudioInfo
   */
  Glib::RefPtr<Gst::DiscovererAudioInfo> wrap(GstDiscovererAudioInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::DiscovererVideoInfo
   */
  Glib::RefPtr<Gst::DiscovererVideoInfo> wrap(GstDiscovererVideoInfo* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_DISCOVERERINFO_H */

