// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_TAGSETTER_H
#define _GSTREAMERMM_TAGSETTER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <glibmm/interface.h>
#include <gstreamermm/enums.h>
#include <gstreamermm/taglist.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstTagSetter GstTagSetter;
typedef struct _GstTagSetterClass GstTagSetterClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class TagSetter_Class; } // namespace Gst
namespace Gst
{

/** An interface that allows setting and retrieval of media metadata.
 * Elements that support changing a stream's metadata will implement this
 * interface. Examples of such elements are 'vorbisenc', 'theoraenc' and
 * 'id3v2mux'.
 *
 * If you just want to retrieve metadata in your application then all you need
 * to do is watch for tag messages on your pipeline's bus. This interface is
 * only for setting metadata, not for extracting it. To set tags from the
 * application, find tagsetter elements and set tags using e.g. merge_tags() or
 * add_tags(). The application should do that before the element goes to
 * Gst::STATE_PAUSED.
 * @ingroup GstInterfaces
 */

class TagSetter : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef TagSetter CppObjectType;
  typedef TagSetter_Class CppClassType;
  typedef GstTagSetter BaseObjectType;
  typedef GstTagSetterInterface BaseClassType;

private:
  friend class TagSetter_Class;
  static CppClassType tagsetter_class_;

  // noncopyable
  TagSetter(const TagSetter&);
  TagSetter& operator=(const TagSetter&);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  TagSetter();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit TagSetter(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit TagSetter(GstTagSetter* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~TagSetter();

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstTagSetter*       gobj()       { return reinterpret_cast<GstTagSetter*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstTagSetter* gobj() const { return reinterpret_cast<GstTagSetter*>(gobject_); }

private:


public:
  
  /** Reset the internal taglist. Elements should call this from within the
   * state-change handler.
   * 
   */
  void reset_tags();
  
  /** Merges the given list into the setter's list using the given mode.
   * 
   * @param list A tag list to merge from.
   * @param mode The mode to merge with.
   */
  void merge_tags(const Gst::TagList& list, TagMergeMode mode =  TAG_MERGE_PREPEND);

  /** Adds the given Glib::ValueBase on the setter using the given merge mode. 
   *
   * @param tag The tag to set.
   * @param value The value to set the tag to.
   * @param mode The mode to use.
   */
  void add_tag(Tag tag, const Glib::ValueBase& value, TagMergeMode mode = TAG_MERGE_PREPEND);
  

  /** Adds the given Glib::ValueBase on the setter using the given merge mode. 
   *
   * @param tag The tag to set.
   * @param value The value to set the tag to.
   * @param mode The mode to use.
   */
  void add_tag(const Glib::ustring& tag, const Glib::ValueBase& value,
    TagMergeMode mode = TAG_MERGE_PREPEND);

  /** Adds the given value on the setter using the given merge mode.
   *
   * @param tag The tag to set.
   * @param data The value to set the tag to (this may be any supported C++
   * type).
   * @param mode The mode to use.
   */
  template <class DataType>
  void add_tag(Tag tag, const DataType& data, TagMergeMode mode = TAG_MERGE_PREPEND);

  /** Adds the given value on the setter using the given merge mode.
   *
   * @param tag The tag to set.
   * @param data The value to set the tag to (this may be any supported C++
   * type).
   * @param mode The mode to use.
   */
  template <class DataType>
    void add_tag(const Glib::ustring& tag, const DataType& data,
    TagMergeMode mode = TAG_MERGE_PREPEND);

  /** Adds the given value on the setter using the given merge mode. 
   *
   * @param tag The tag to set.
   * @param data The value to set the tag to.
   * @param mode The mode to use.
   */
  void add_tag(Tag tag, const char* data, TagMergeMode mode = TAG_MERGE_PREPEND);

  /** Adds the given value on the setter using the given merge mode. 
   *
   * @param tag The tag to set.
   * @param data The value to set the tag to.
   * @param mode The mode to use.
   */
  void add_tag(const Glib::ustring& tag, const char* data,
    TagMergeMode mode = TAG_MERGE_PREPEND);

// A copy is taken so that the original is not freed by the wrapper.
 

  /** Returns the current list of tags the setter uses.  The list should not be
   * modified or freed.
   * 
   * This function is not thread-safe.
   * 
   * @return A current snapshot of the taglist used in the
   * setter or <tt>0</tt> if none is used.
   */
  const Gst::TagList get_tag_list() const;

  
  /** Sets the given merge mode that is used for adding tags from events to tags
   * specified by this interface. The default is Gst::TAG_MERGE_KEEP, which keeps
   * the tags set with this interface and discards tags from events.
   * 
   * @param mode The mode with which tags are added.
   */
  void set_tag_merge_mode(TagMergeMode mode);
  
  /** Queries the mode by which tags inside the setter are overwritten by tags
   * from events
   * 
   * @return The merge mode used inside the element.
   */
  TagMergeMode get_tag_merge_mode() const;

  //Variable argument functions are ignored.
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS

/************************** Gst::TagSetter ***************************/

template <class DataType>
void TagSetter::add_tag(Tag tag, const DataType& data, TagMergeMode mode)
{
  typedef Glib::Value<DataType> ValueType;

  ValueType value;
  value.init(ValueType::value_type());
  value.set(data);
  this->add_tag(tag, (Glib::ValueBase)(value), mode);
}

template <class DataType>
  void TagSetter::add_tag(const Glib::ustring& tag, const DataType& data,
  TagMergeMode mode)
{
  typedef Glib::Value<DataType> ValueType;

  ValueType value;
  value.init(ValueType::value_type());
  value.set(data);
  this->add_tag(tag, (Glib::ValueBase)(value), mode);
}

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::TagSetter
   */
  Glib::RefPtr<Gst::TagSetter> wrap(GstTagSetter* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_TAGSETTER_H */

