/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AType;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.ErrorsCounter;

public class DepthTraversal {
    public static void visit(IDexTreeVisitor visitor, ClassNode cls) {
        try {
            if (visitor.visit(cls)) {
                for (ClassNode inCls : cls.getInnerClasses()) {
                    DepthTraversal.visit(visitor, inCls);
                }
                for (MethodNode mth : cls.getMethods()) {
                    DepthTraversal.visit(visitor, mth);
                }
            }
        }
        catch (Throwable e) {
            ErrorsCounter.classError(cls, e.getClass().getSimpleName() + " in pass: " + visitor.getClass().getSimpleName(), e);
        }
    }

    public static void visit(IDexTreeVisitor visitor, MethodNode mth) {
        if (mth.contains(AType.JADX_ERROR)) {
            return;
        }
        try {
            visitor.visit(mth);
        }
        catch (Throwable e) {
            ErrorsCounter.methodError(mth, e.getClass().getSimpleName() + " in pass: " + visitor.getClass().getSimpleName(), e);
        }
    }
}

