/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.api.JadxDecompiler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;

public class Utils {
    public static final String JADX_API_PACKAGE = JadxDecompiler.class.getPackage().getName();

    private Utils() {
    }

    public static String cleanObjectName(String obj) {
        int last = obj.length() - 1;
        if (obj.charAt(0) == 'L' && obj.charAt(last) == ';') {
            return obj.substring(1, last).replace('/', '.');
        }
        return obj;
    }

    public static String makeQualifiedObjectName(String obj) {
        return 'L' + obj.replace('.', '/') + ';';
    }

    public static String listToString(Iterable<?> list) {
        if (list == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        Iterator<?> it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            str.append(o);
            if (!it.hasNext()) continue;
            str.append(", ");
        }
        return str.toString();
    }

    public static String arrayToString(Object[] array) {
        if (array == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        Utils.filterRecursive(throwable);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    private static void filterRecursive(Throwable th) {
        try {
            Utils.filter(th);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Throwable cause = th.getCause();
        if (cause != null) {
            Utils.filterRecursive(cause);
        }
    }

    private static void filter(Throwable th) {
        StackTraceElement[] stackTrace = th.getStackTrace();
        int cutIndex = -1;
        int length = stackTrace.length;
        for (int i = 0; i < length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            if (stackTraceElement.getClassName().startsWith(JADX_API_PACKAGE)) {
                cutIndex = i;
                continue;
            }
            if (cutIndex <= 0) continue;
            cutIndex = i;
            break;
        }
        if (cutIndex > 0 && cutIndex < length) {
            th.setStackTrace(Arrays.copyOfRange(stackTrace, 0, cutIndex));
        }
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }
}

