/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.UIManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class SplashScreen
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final FontMetrics fm;
    private final JWindow win;
    private final Image image;
    private int progress;
    private static final int PROGRESS_HEIGHT = 20;
    private static final int PROGRESS_COUNT = 28;
    private String label;
    private String lastLabel;
    private long firstAdvanceTime = System.currentTimeMillis();
    private long lastAdvanceTime = System.currentTimeMillis();
    private Font labelFont = UIManager.getFont("Label.font").deriveFont(9.8f);
    private Color versionColor1 = new Color(55, 55, 55);
    private Color versionColor2 = new Color(255, 255, 255, 50);
    private java.awt.SplashScreen realSplash = java.awt.SplashScreen.getSplashScreen();

    public SplashScreen() {
        this.fm = this.getFontMetrics(this.labelFont);
        if (this.realSplash == null) {
            Object object;
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setBackground(Color.white);
            this.image = this.getToolkit().getImage(this.getClass().getResource("/org/gjt/sp/jedit/icons/splash.png"));
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (Exception exception) {
                Log.log(9, this, exception);
            }
            Dimension dimension = this.getToolkit().getScreenSize();
            this.win = new JWindow();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            GraphicsDevice graphicsDevice = graphicsDeviceArray[0];
            if (graphicsDevice != null && (object = graphicsDevice.getDefaultConfiguration()) != null) {
                Rectangle rectangle = ((GraphicsConfiguration)object).getBounds();
                dimension = new Dimension(rectangle.width, rectangle.height);
            }
            object = new Dimension(this.image.getWidth(this) + 2, this.image.getHeight(this) + 2);
            this.win.setSize((Dimension)object);
            this.win.getContentPane().add((Component)this, "Center");
            this.win.setLocation((dimension.width - ((Dimension)object).width) / 2, (dimension.height - ((Dimension)object).height) / 2);
            this.win.validate();
            this.win.setVisible(true);
        } else {
            this.win = null;
            this.image = null;
        }
    }

    public void dispose() {
        if (this.realSplash == null) {
            this.win.dispose();
        } else if (this.realSplash.isVisible()) {
            this.realSplash.close();
        }
    }

    public synchronized void advance() {
        this.logAdvanceTime(null);
        ++this.progress;
        this.repaint();
        if (this.realSplash == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.log(9, this, interruptedException);
            }
        }
    }

    public synchronized void advance(String string) {
        this.logAdvanceTime(string);
        ++this.progress;
        this.label = string;
        this.repaint();
        if (this.realSplash == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Log.log(9, this, interruptedException);
            }
        }
    }

    private void logAdvanceTime(String string) {
        long l = System.currentTimeMillis();
        if (this.lastLabel != null) {
            Log.log(1, SplashScreen.class, this.lastLabel + ':' + (l - this.lastAdvanceTime) + "/" + (l - this.firstAdvanceTime) + "ms");
        }
        if (string != null) {
            this.lastLabel = string;
            this.lastAdvanceTime = l;
        }
    }

    @Override
    public void repaint() {
        if (this.realSplash == null) {
            super.repaint();
            return;
        }
        Graphics2D graphics2D = this.realSplash.createGraphics();
        if (graphics2D == null) {
            Log.log(9, SplashScreen.class, "using native splash screen, but can't obtain graphics from it");
            return;
        }
        Dimension dimension = this.realSplash.getSize();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setPaintMode();
        this.doPaintContents(graphics2D, dimension);
        this.realSplash.update();
    }

    @Override
    public synchronized void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.drawImage(this.image, 1, 1, this);
        this.doPaintContents(graphics, dimension);
        this.notify();
    }

    private void doPaintContents(Graphics graphics, Dimension dimension) {
        int n;
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(Color.white);
        graphics.fillRect(1, dimension.height - 1 - 20, (dimension.width - 2) * this.progress / 28, 20);
        graphics.setColor(Color.black);
        if (this.label != null) {
            int n2 = (dimension.width - this.fm.stringWidth(this.label)) / 2;
            n = dimension.height - 2 - 20 + (20 + this.fm.getAscent() + this.fm.getDescent()) / 2;
            this.paintString(graphics, this.label, n2, n);
        }
        String string = "version " + jEdit.getVersion();
        n = dimension.width / 2 - this.fm.stringWidth(string) / 2;
        int n3 = dimension.height - 20 - this.fm.getDescent() - 3;
        this.paintString(graphics, string, n, n3);
    }

    private void paintString(Graphics graphics, String string, int n, int n2) {
        graphics.setFont(this.labelFont);
        graphics.setColor(this.versionColor1);
        graphics.drawString(string, n, n2);
        graphics.setColor(this.versionColor2);
        graphics.drawString(string, n + 1, n2 + 1);
    }
}

