/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui.tray;

import java.awt.AWTException;
import java.awt.SystemTray;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.gui.tray.JEditSwingTrayIcon;
import org.gjt.sp.jedit.gui.tray.JEditTrayIcon;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class JTrayIconManager {
    private static JEditTrayIcon trayIcon;
    private static boolean restore;
    private static String userDir;
    private static String[] args;

    public static void setTrayIconArgs(boolean bl, String string, String[] stringArray) {
        restore = bl;
        userDir = string;
        args = stringArray;
    }

    public static void addTrayIcon() {
        if (trayIcon == null && SystemTray.isSupported()) {
            SystemTray systemTray = SystemTray.getSystemTray();
            String string = jEdit.getProperty("systrayicon.service", "swing");
            trayIcon = ServiceManager.getService(JEditTrayIcon.class, string);
            if (trayIcon == null) {
                if ("swing".equals(string)) {
                    Log.log(9, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name swing");
                    return;
                }
                Log.log(7, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name " + string);
                trayIcon = ServiceManager.getService(JEditTrayIcon.class, "swing");
            }
            if (trayIcon == null) {
                Log.log(9, JTrayIconManager.class, "No service " + JEditTrayIcon.class.getName() + " with name swing");
                return;
            }
            trayIcon.setTrayIconArgs(restore, userDir, args);
            try {
                systemTray.add(trayIcon);
            }
            catch (AWTException aWTException) {
                Log.log(9, JEditSwingTrayIcon.class, "Unable to add Tray icon", aWTException);
                trayIcon = null;
                return;
            }
            if (trayIcon instanceof EBComponent) {
                EditBus.addToBus(trayIcon);
            }
        }
    }

    public static void removeTrayIcon() {
        if (trayIcon != null) {
            SystemTray.getSystemTray().remove(trayIcon);
            if (trayIcon instanceof EBComponent) {
                EditBus.removeFromBus(trayIcon);
            }
            trayIcon = null;
        }
    }
}

