/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.java.BS;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceFileReader;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class SurfaceGenerator {
    public Parameters params;
    public JvxlData jvxlData;
    public MeshData meshData;
    public VolumeData volumeDataTemp;
    public MeshDataServer meshDataServer;
    public AtomDataServer atomDataServer;
    public MarchingSquares marchingSquares;
    public String version;
    public boolean isValid = true;
    public String fileType;
    public BS bsVdw;
    private int colorPtr;
    private SurfaceReader surfaceReader;
    private OC out;
    private Object readerData;
    private final V3 vAB = new V3();
    private final V3 vNorm = new V3();
    private final P3 ptRef = P3.new3((float)0.0f, (float)0.0f, (float)1.0E15f);

    public SurfaceGenerator(AtomDataServer atomDataServer, MeshDataServer meshDataServer, MeshData meshData, JvxlData jvxlData) {
        this.atomDataServer = atomDataServer;
        this.meshDataServer = meshDataServer;
        this.params = new Parameters();
        this.meshData = meshData == null ? new MeshData() : meshData;
        this.jvxlData = jvxlData == null ? new JvxlData() : jvxlData;
        this.volumeDataTemp = new VolumeData();
        this.initializeIsosurface();
    }

    public void setJvxlData(JvxlData jvxlData) {
        this.jvxlData = jvxlData;
        if (jvxlData != null) {
            jvxlData.version = this.version;
        }
    }

    public boolean setProp(String propertyName, Object value, BS bs) {
        if ("debug" == propertyName) {
            boolean TF;
            this.params.logMessages = TF = ((Boolean)value).booleanValue();
            this.params.logCube = TF;
            return true;
        }
        if ("init" == propertyName) {
            this.initializeIsosurface();
            if (value instanceof Parameters) {
                this.params = (Parameters)value;
            } else {
                this.params.script = (String)value;
                if (this.params.script != null && this.params.script.indexOf(";#") >= 0) {
                    this.params.script = PT.rep((String)this.params.script, (String)";#", (String)"; #");
                }
            }
            return false;
        }
        if ("silent" == propertyName) {
            this.params.isSilent = true;
            return true;
        }
        if ("map" == propertyName) {
            this.params.resetForMapping((Boolean)value);
            if (this.surfaceReader != null) {
                this.surfaceReader.minMax = null;
            }
            return true;
        }
        if ("finalize" == propertyName) {
            this.initializeIsosurface();
            return true;
        }
        if ("clear" == propertyName) {
            if (this.surfaceReader != null) {
                this.surfaceReader.discardTempData(true);
            }
            return false;
        }
        if ("fileIndex" == propertyName) {
            this.params.fileIndex = (Integer)value;
            if (this.params.fileIndex < 0) {
                this.params.fileIndex = 0;
            }
            this.params.readAllData = false;
            return true;
        }
        if ("blockData" == propertyName) {
            this.params.blockCubeData = (Boolean)value;
            return true;
        }
        if ("withinPoints" == propertyName) {
            this.params.boundingBox = (P3[])((Object[])value)[1];
            return true;
        }
        if ("boundingBox" == propertyName) {
            P3[] pts = (P3[])value;
            this.params.boundingBox = new P3[]{P3.newP((T3)pts[0]), P3.newP((T3)pts[pts.length - 1])};
            return true;
        }
        if ("func" == propertyName) {
            this.params.func = value;
            return true;
        }
        if ("intersection" == propertyName) {
            this.params.intersection = (BS[])value;
            return true;
        }
        if ("bsSolvent" == propertyName) {
            this.params.bsSolvent = (BS)value;
            return true;
        }
        if ("select" == propertyName) {
            this.params.bsSelected = (BS)value;
            return true;
        }
        if ("ignore" == propertyName) {
            this.params.bsIgnore = (BS)value;
            return true;
        }
        if ("propertySmoothing" == propertyName) {
            this.params.propertySmoothing = (Boolean)value;
            return true;
        }
        if ("propertyDistanceMax" == propertyName) {
            this.params.propertyDistanceMax = ((Float)value).floatValue();
            return true;
        }
        if ("propertySmoothingPower" == propertyName) {
            this.params.propertySmoothingPower = (Integer)value;
            return true;
        }
        if ("title" == propertyName) {
            if (value == null) {
                this.params.title = null;
                return true;
            }
            if (AU.isAS((Object)value)) {
                this.params.title = (String[])value;
                if (Logger.debugging) {
                    for (int i = 0; i < this.params.title.length; ++i) {
                        if (this.params.title[i].length() <= 0) continue;
                        Logger.info((String)this.params.title[i]);
                    }
                }
            }
            return true;
        }
        if ("sigma" == propertyName) {
            this.params.cutoff = this.params.sigma = ((Float)value).floatValue();
            this.params.isPositiveOnly = false;
            this.params.cutoffAutomatic = false;
            return true;
        }
        if ("cutoff" == propertyName) {
            this.params.cutoff = ((Float)value).floatValue();
            this.params.isPositiveOnly = false;
            this.params.cutoffAutomatic = false;
            return true;
        }
        if ("parameters" == propertyName) {
            this.params.parameters = AU.ensureLengthA((float[])((float[])value), (int)2);
            if (this.params.parameters.length > 0 && this.params.parameters[0] != 0.0f) {
                this.params.cutoff = this.params.parameters[0];
            }
            return true;
        }
        if ("cutoffPositive" == propertyName) {
            this.params.cutoff = ((Float)value).floatValue();
            this.params.isPositiveOnly = true;
            return true;
        }
        if ("cap" == propertyName || "slab" == propertyName) {
            if (value != null) {
                this.params.addSlabInfo((Object[])value);
            }
            return true;
        }
        if ("scale" == propertyName) {
            this.params.scale = ((Float)value).floatValue();
            return true;
        }
        if ("scale3d" == propertyName) {
            this.params.scale3d = ((Float)value).floatValue();
            return true;
        }
        if ("angstroms" == propertyName) {
            this.params.isAngstroms = true;
            return true;
        }
        if ("resolution" == propertyName) {
            float resolution = ((Float)value).floatValue();
            this.params.resolution = resolution > 0.0f ? resolution : Float.MAX_VALUE;
            return true;
        }
        if ("downsample" == propertyName) {
            int rate = (Integer)value;
            this.params.downsampleFactor = rate >= 0 ? rate : 0;
            return true;
        }
        if ("anisotropy" == propertyName) {
            if ((this.params.dataType & 0x20) == 0) {
                this.params.setAnisotropy((P3)value);
            }
            return true;
        }
        if ("eccentricity" == propertyName) {
            this.params.setEccentricity((P4)value);
            return true;
        }
        if ("addHydrogens" == propertyName) {
            this.params.addHydrogens = (Boolean)value;
            return true;
        }
        if ("squareData" == propertyName) {
            this.params.isSquared = value == null ? false : (Boolean)value;
            return true;
        }
        if ("squareLinear" == propertyName) {
            this.params.isSquaredLinear = value == null ? false : (Boolean)value;
            return true;
        }
        if ("gridPoints" == propertyName) {
            this.params.iAddGridPoints = true;
            return true;
        }
        if ("atomIndex" == propertyName) {
            this.params.atomIndex = (Integer)value;
            return true;
        }
        if ("insideOut" == propertyName) {
            this.params.insideOut = true;
            return true;
        }
        if ("sign" == propertyName) {
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.colorPtr = 0;
            return true;
        }
        if ("colorRGB" == propertyName) {
            int rgb;
            this.params.colorPos = this.params.colorPosLCAO = (rgb = ((Integer)value).intValue());
            this.params.colorRgb = this.params.colorPosLCAO;
            if (this.colorPtr++ == 0) {
                this.params.colorNeg = this.params.colorNegLCAO = rgb;
            } else {
                this.params.colorRgb = Integer.MAX_VALUE;
            }
            return true;
        }
        if ("monteCarloCount" == propertyName) {
            this.params.psi_monteCarloCount = (Integer)value;
            return true;
        }
        if ("rangeAll" == propertyName) {
            this.params.rangeAll = true;
            return true;
        }
        if ("rangeSelected" == propertyName) {
            this.params.rangeSelected = true;
            return true;
        }
        if ("red" == propertyName) {
            this.params.valueMappedToRed = ((Float)value).floatValue();
            return true;
        }
        if ("blue" == propertyName) {
            this.params.valueMappedToBlue = ((Float)value).floatValue();
            if (this.params.valueMappedToRed > this.params.valueMappedToBlue) {
                float f = this.params.valueMappedToRed;
                this.params.valueMappedToRed = this.params.valueMappedToBlue;
                this.params.valueMappedToBlue = f;
                this.params.isColorReversed = !this.params.isColorReversed;
            }
            this.params.rangeDefined = true;
            this.params.rangeAll = false;
            return true;
        }
        if ("reverseColor" == propertyName) {
            this.params.isColorReversed = true;
            return true;
        }
        if ("setColorScheme" == propertyName) {
            this.getSurfaceSets();
            this.params.colorBySets = true;
            this.mapSurface();
            return true;
        }
        if ("center" == propertyName) {
            this.params.center.setT((T3)((P3)value));
            return true;
        }
        if ("origin" == propertyName) {
            this.params.origin = (P3)value;
            return true;
        }
        if ("step" == propertyName) {
            this.params.steps = (P3)value;
            return true;
        }
        if ("modelInvRotation" == propertyName) {
            this.params.modelInvRotation = (M4)value;
            return true;
        }
        if ("point" == propertyName) {
            this.params.points = (P3)value;
            return true;
        }
        if ("withinDistance" == propertyName) {
            this.params.distance = ((Float)value).floatValue();
            return true;
        }
        if ("withinPoint" == propertyName) {
            this.params.point = (P3)value;
            return true;
        }
        if ("progressive" == propertyName) {
            this.params.isXLowToHigh = true;
            return true;
        }
        if ("phase" == propertyName) {
            String color = (String)value;
            this.params.isCutoffAbsolute = true;
            this.params.colorBySign = true;
            this.params.colorByPhase = true;
            this.params.colorPhase = SurfaceReader.getColorPhaseIndex(color);
            if (this.params.colorPhase < 0) {
                Logger.warn((String)(" invalid color phase: " + color));
                this.params.colorPhase = 0;
            }
            boolean bl = this.params.colorByPhase = this.params.colorPhase != 0;
            if (this.params.state >= 2) {
                this.params.dataType = this.params.surfaceType;
                this.params.state = 3;
                this.params.isBicolorMap = true;
                this.surfaceReader.applyColorScale();
            }
            return true;
        }
        if ("radius" == propertyName) {
            Logger.info((String)("solvent probe radius set to " + value));
            this.params.atomRadiusData = (RadiusData)value;
            return true;
        }
        if ("envelopeRadius" == propertyName) {
            this.params.envelopeRadius = ((Float)value).floatValue();
            return true;
        }
        if ("cavityRadius" == propertyName) {
            this.params.cavityRadius = ((Float)value).floatValue();
            return true;
        }
        if ("cavity" == propertyName) {
            this.params.isCavity = true;
            return true;
        }
        if ("doFullMolecular" == propertyName) {
            this.params.doFullMolecular = true;
            return true;
        }
        if ("pocket" == propertyName) {
            this.params.pocket = (Boolean)value;
            this.params.fullyLit = this.params.pocket;
            return true;
        }
        if ("minset" == propertyName) {
            this.params.minSet = (Integer)value;
            return true;
        }
        if ("maxset" == propertyName) {
            this.params.maxSet = (Integer)value;
            return true;
        }
        if ("plane" == propertyName) {
            this.params.setPlane((P4)value);
            return true;
        }
        if ("contour" == propertyName) {
            this.params.isContoured = true;
            if (AU.isAF((Object)value)) {
                this.params.contoursDiscrete = (float[])value;
                this.params.nContours = this.params.contoursDiscrete.length;
            } else if (value instanceof P3) {
                P3 pt = this.params.contourIncrements = (P3)value;
                float from = pt.x;
                float to = pt.y;
                float step = pt.z;
                if (step <= 0.0f) {
                    step = 1.0f;
                }
                int n = 0;
                float p = from;
                while (p <= to + step / 10.0f) {
                    p += step;
                    ++n;
                }
                this.params.contoursDiscrete = new float[n];
                p = from;
                int i = 0;
                while (i < n) {
                    this.params.contoursDiscrete[i] = p;
                    ++i;
                    p += step;
                }
                this.params.nContours = n;
            } else {
                int n = (Integer)value;
                this.params.thisContour = 0;
                if (n == 0) {
                    this.params.nContours = 9;
                } else if (n > 0) {
                    this.params.nContours = n;
                } else {
                    this.params.thisContour = -n;
                }
            }
            return true;
        }
        if ("colorDiscrete" == propertyName) {
            this.params.contourColixes = (short[])value;
            return true;
        }
        if ("colorDensity" == propertyName) {
            this.params.colorDensity = true;
            if (value != null) {
                this.params.pointSize = ((Float)value).floatValue();
            }
            return false;
        }
        if ("fullPlane" == propertyName) {
            this.params.contourFromZero = (Boolean)value == false;
            return true;
        }
        if ("mapLattice" == propertyName) {
            this.params.mapLattice = (P3)value;
            return true;
        }
        if ("extendGrid" == propertyName) {
            this.params.extendGrid = ((Float)value).floatValue();
            return true;
        }
        if ("property" == propertyName) {
            this.params.dataType = 1206;
            this.params.theProperty = (float[])value;
            this.mapSurface();
            return true;
        }
        if ("sphere" == propertyName) {
            this.params.setSphere(((Float)value).floatValue(), false);
            this.readerData = Float.valueOf(this.params.distance);
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("geodesic" == propertyName) {
            this.params.setSphere(((Float)value).floatValue(), true);
            this.readerData = Float.valueOf(this.params.distance);
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("ellipsoid" == propertyName) {
            if (value instanceof P4) {
                this.params.setEllipsoidP4((P4)value);
            } else if (AU.isAF((Object)value)) {
                this.params.setEllipsoidAF((float[])value);
            } else {
                return true;
            }
            this.readerData = Float.valueOf(this.params.distance);
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("ellipsoid3" == propertyName) {
            this.params.setEllipsoidAF((float[])value);
            this.readerData = Float.valueOf(this.params.distance);
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("lp" == propertyName) {
            this.params.setLp((P4)value);
            this.readerData = new float[]{3.0f, 2.0f, 0.0f, 15.0f, 0.0f};
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("rad" == propertyName) {
            this.params.setRadical((P4)value);
            this.readerData = new float[]{3.0f, 2.0f, 0.0f, 15.0f, 0.0f};
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("lobe" == propertyName) {
            this.params.setLobe((P4)value);
            this.readerData = new float[]{3.0f, 2.0f, 0.0f, 15.0f, 0.0f};
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.generateSurface();
            return true;
        }
        if ("hydrogenOrbital" == propertyName) {
            if (!this.params.setAtomicOrbital((float[])value)) {
                this.isValid = false;
                return true;
            }
            this.readerData = new float[]{this.params.psi_n, this.params.psi_l, this.params.psi_m, this.params.psi_Znuc, this.params.psi_monteCarloCount};
            this.surfaceReader = this.newReader("IsoShapeReader");
            this.processState();
            return true;
        }
        if ("functionXY" == propertyName) {
            this.params.setFunctionXY((Lst<Object>)((Lst)value));
            if (this.params.isContoured) {
                this.volumeDataTemp.setPlaneParameters(this.params.thePlane == null ? (this.params.thePlane = P4.new4((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f)) : this.params.thePlane);
            }
            if (((String)this.params.functionInfo.get(0)).indexOf("_xyz") >= 0) {
                this.getFunctionZfromXY();
            }
            this.processState();
            return true;
        }
        if ("functionXYZ" == propertyName) {
            this.params.setFunctionXYZ((Lst<Object>)((Lst)value));
            this.processState();
            return true;
        }
        if ("lcaoType" == propertyName) {
            this.params.setLcao((String)value, this.colorPtr);
            return true;
        }
        if ("lcaoCartoonCenter" == propertyName) {
            if (++this.params.state != 2) {
                return true;
            }
            if (Float.isNaN(this.params.center.x)) {
                this.params.center.setT((T3)((V3)value));
            }
            return false;
        }
        if ("molecular" == propertyName || "solvent" == propertyName || "sasurface" == propertyName || "nomap" == propertyName) {
            this.params.setSolvent(propertyName, ((Float)value).floatValue());
            if (!this.params.isSilent) {
                Logger.info((String)this.params.calculationType);
            }
            this.processState();
            return true;
        }
        if ("moData" == propertyName) {
            this.params.moData = (Map)value;
            return true;
        }
        if ("mepCalcType" == propertyName) {
            this.params.mep_calcType = (Integer)value;
            return true;
        }
        if ("mep" == propertyName) {
            this.params.setMep((float[])value, false);
            this.processState();
            return true;
        }
        if ("mlp" == propertyName) {
            this.params.setMep((float[])value, true);
            this.processState();
            return true;
        }
        if ("nci" == propertyName) {
            boolean isPromolecular = (Boolean)value;
            this.params.setNci(isPromolecular);
            if (isPromolecular) {
                this.processState();
            }
            return true;
        }
        if ("calculationType" == propertyName) {
            this.params.calculationType = (String)value;
            return true;
        }
        if ("charges" == propertyName) {
            this.params.theProperty = (float[])value;
            return true;
        }
        if ("randomSeed" == propertyName) {
            this.params.randomSeed = (Integer)value;
            return true;
        }
        if ("molecularOrbital" == propertyName) {
            int iMo = 0;
            float[] linearCombination = null;
            if (value instanceof Integer) {
                iMo = (Integer)value;
            } else {
                linearCombination = (float[])value;
            }
            this.params.setMO(iMo, linearCombination);
            Logger.info((String)this.params.calculationType);
            this.processState();
            return true;
        }
        if ("fileType" == propertyName) {
            this.fileType = (String)value;
            return true;
        }
        if ("fileName" == propertyName) {
            this.params.fileName = (String)value;
            return true;
        }
        if ("outputChannel" == propertyName) {
            this.out = (OC)value;
            return true;
        }
        if ("readFile" == propertyName) {
            this.surfaceReader = this.setFileData((Viewer)this.atomDataServer, value);
            if (this.surfaceReader == null) {
                Logger.error((String)"Could not set the surface data");
                return true;
            }
            this.surfaceReader.setOutputChannel(this.out);
            this.generateSurface();
            return true;
        }
        if ("mapColor" == propertyName) {
            this.surfaceReader = this.setFileData((Viewer)this.atomDataServer, value);
            if (this.surfaceReader == null) {
                Logger.error((String)"Could not set the mapping data");
                return true;
            }
            this.surfaceReader.setOutputChannel(this.out);
            this.mapSurface();
            return true;
        }
        if ("getSurfaceSets" == propertyName) {
            this.getSurfaceSets();
            return true;
        }
        if ("periodic" == propertyName) {
            this.params.isPeriodic = true;
        }
        return false;
    }

    private SurfaceReader newReader(String name) {
        SurfaceReader sr = (SurfaceReader)SurfaceGenerator.getInterface(name);
        if (sr != null) {
            sr.init(this);
        }
        return sr;
    }

    private SurfaceReader newReaderBr(String name, BufferedReader br) {
        SurfaceFileReader sr = (SurfaceFileReader)SurfaceGenerator.getInterface(name);
        if (sr != null) {
            sr.init2(this, br);
        }
        return sr;
    }

    private static Object getInterface(String name) {
        try {
            Class<?> x = Class.forName("org.jmol.jvxl.readers." + name);
            return x == null ? null : x.newInstance();
        }
        catch (Exception e) {
            Logger.error((String)("Interface.java Error creating instance for " + name + ": \n" + e.toString()));
            return null;
        }
    }

    private void getSurfaceSets() {
        if (this.meshDataServer == null) {
            this.meshData.getSurfaceSet();
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
            this.meshData.getSurfaceSet();
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    private void processState() {
        if (this.params.state == 1 && this.params.thePlane != null) {
            ++this.params.state;
        }
        if (this.params.state >= 2) {
            this.mapSurface();
        } else {
            this.generateSurface();
        }
    }

    private boolean setReader() {
        this.readerData = null;
        if (this.surfaceReader != null) {
            return !this.surfaceReader.vertexDataOnly;
        }
        switch (this.params.dataType) {
            case 1205: {
                this.surfaceReader = this.newReader("IsoPlaneReader");
                break;
            }
            case 1206: {
                this.surfaceReader = this.newReader("AtomPropertyMapper");
                break;
            }
            case 1328: 
            case 1329: {
                Object object = this.readerData = this.params.dataType == 1328 ? "Mep" : "Mlp";
                if (this.params.state == 3) {
                    this.surfaceReader = this.newReader("AtomPropertyMapper");
                    break;
                }
                this.surfaceReader = this.newReader("Iso" + this.readerData + "Reader");
                break;
            }
            case 1333: {
                this.surfaceReader = this.newReader("IsoIntersectReader");
                break;
            }
            case 1195: 
            case 1196: 
            case 1203: {
                this.surfaceReader = this.newReader("IsoSolventReader");
                break;
            }
            case 1837: 
            case 1844: {
                this.surfaceReader = this.newReader("IsoMOReader");
                break;
            }
            case 8: {
                this.surfaceReader = this.newReader("IsoFxyReader");
                break;
            }
            case 9: {
                this.surfaceReader = this.newReader("IsoFxyzReader");
            }
        }
        if (Logger.debugging) {
            Logger.info((String)("Using surface reader " + this.surfaceReader));
        }
        if (this.params.isSilent && this.surfaceReader != null) {
            this.surfaceReader.isQuiet = true;
        }
        return true;
    }

    private void generateSurface() {
        boolean haveMeshDataServer;
        if (++this.params.state != 2) {
            return;
        }
        this.setReader();
        boolean bl = haveMeshDataServer = this.meshDataServer != null;
        if (this.params.colorBySign) {
            this.params.isBicolorMap = true;
        }
        if (this.surfaceReader == null) {
            Logger.error((String)("surfaceReader is null for " + this.params.dataType));
            return;
        }
        if (!this.surfaceReader.createIsosurface(false)) {
            Logger.error((String)"Could not create isosurface");
            this.params.cutoff = Float.NaN;
            this.surfaceReader.closeReader();
            return;
        }
        if (this.params.pocket != null && haveMeshDataServer) {
            this.surfaceReader.selectPocket(this.params.pocket == false);
        }
        if (this.params.minSet > 0) {
            this.surfaceReader.excludeMinimumSet();
        }
        if (this.params.maxSet > 0) {
            this.surfaceReader.excludeMaximumSet();
        }
        if (this.params.slabInfo != null) {
            this.surfaceReader.slabIsosurface(this.params.slabInfo);
        }
        if (haveMeshDataServer && this.meshDataServer.notifySurfaceGenerationCompleted()) {
            this.surfaceReader.hasColorData = false;
        }
        if (this.jvxlData.thisSet >= 0) {
            this.getSurfaceSets();
        }
        if (this.jvxlData.jvxlDataIs2dContour) {
            this.surfaceReader.colorIsosurface();
            this.params.state = 3;
        }
        if (this.jvxlData.jvxlDataIsColorDensity) {
            this.params.state = 3;
        }
        if (this.params.colorBySign || this.params.isBicolorMap) {
            this.params.state = 3;
            this.surfaceReader.applyColorScale();
        }
        if (this.jvxlData.vertexColorMap != null) {
            this.jvxlData.vertexColorMap = null;
            this.surfaceReader.hasColorData = false;
        }
        this.surfaceReader.jvxlUpdateInfo();
        this.marchingSquares = this.surfaceReader.marchingSquares;
        this.surfaceReader.discardTempData(false);
        this.params.mappedDataMin = Float.MAX_VALUE;
        this.surfaceReader.closeReader();
        if (this.params.state != 3 && (this.surfaceReader.hasColorData || this.params.colorDensity)) {
            this.params.state = 3;
            this.colorIsosurface();
        }
        this.surfaceReader = null;
    }

    private void mapSurface() {
        if (this.params.state == 1 && this.params.thePlane != null) {
            ++this.params.state;
        }
        if (++this.params.state < 3) {
            return;
        }
        if (!this.setReader()) {
            return;
        }
        if (this.params.isPeriodic) {
            this.surfaceReader.volumeData.isPeriodic = true;
        }
        if (this.params.thePlane != null) {
            boolean isSquared = this.params.isSquared;
            this.params.isSquared = false;
            this.params.cutoff = 0.0f;
            this.surfaceReader.volumeData.setMappingPlane(this.params.thePlane);
            this.surfaceReader.createIsosurface(!this.params.isPeriodic);
            this.surfaceReader.volumeData.setMappingPlane(null);
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            if (this.params.dataType == 1205) {
                this.surfaceReader.discardTempData(true);
                return;
            }
            this.params.isSquared = isSquared;
            this.params.mappedDataMin = Float.MAX_VALUE;
            this.surfaceReader.readVolumeData(true);
            if (this.params.mapLattice != null) {
                this.surfaceReader.volumeData.isPeriodic = true;
            }
        } else if (!this.params.colorBySets && !this.params.colorDensity) {
            this.surfaceReader.readAndSetVolumeParameters(true);
            this.params.mappedDataMin = Float.MAX_VALUE;
            this.surfaceReader.readVolumeData(true);
        }
        this.colorIsosurface();
        this.surfaceReader.closeReader();
        this.surfaceReader = null;
    }

    void colorIsosurface() {
        this.surfaceReader.colorIsosurface();
        this.surfaceReader.jvxlUpdateInfo();
        this.surfaceReader.updateTriangles();
        this.surfaceReader.discardTempData(true);
        if (this.meshDataServer != null) {
            this.meshDataServer.notifySurfaceMappingCompleted();
        }
    }

    public Object getProperty(String property, int index) {
        if (property == "jvxlFileData") {
            return JvxlCoder.jvxlGetFileVwr(null, this.jvxlData, null, this.params.title, "", true, index, null, null);
        }
        if (property == "jvxlFileInfo") {
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        return null;
    }

    private SurfaceReader setFileData(Viewer vwr, Object value) {
        String fileType = this.fileType;
        this.fileType = null;
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.containsKey("__pymolSurfaceData__")) {
                this.readerData = map;
                return this.newReaderBr("PyMOLMeshReader", null);
            }
            value = map.get("volumeData");
        }
        if (value instanceof VolumeData) {
            this.volumeDataTemp = (VolumeData)value;
            return this.newReader("VolumeDataReader");
        }
        String data = null;
        if (value instanceof String) {
            data = (String)value;
            value = Rdr.getBR((String)((String)value));
        }
        BufferedReader br = (BufferedReader)value;
        if (fileType == null) {
            fileType = FileManager.determineSurfaceFileType((BufferedReader)br);
        }
        if (fileType != null && fileType.startsWith("UPPSALA")) {
            String fname = this.params.fileName;
            fname = fname.substring(0, fname.indexOf("/", 10));
            this.params.fileName = fname = fname + PT.getQuotedStringAt((String)fileType, (int)(fileType.indexOf("A HREF") + 1));
            value = this.atomDataServer.getBufferedInputStream(fname);
            if (value == null) {
                Logger.error((String)("Isosurface: could not open file " + fname));
                return null;
            }
            try {
                br = Rdr.getBufferedReader((BufferedInputStream)((BufferedInputStream)value), null);
            }
            catch (Exception e) {
                // empty catch block
            }
            fileType = FileManager.determineSurfaceFileType((BufferedReader)br);
        }
        if (fileType == null) {
            fileType = "UNKNOWN";
        }
        Logger.info((String)("data file type was determined to be " + fileType));
        if (fileType.equals("Jvxl+")) {
            return this.newReaderBr("JvxlReader", br);
        }
        this.readerData = new Object[]{this.params.fileName, data};
        if ("MRC DELPHI DSN6".indexOf(fileType.toUpperCase()) >= 0) {
            try {
                br.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            br = null;
            fileType = fileType + "Binary";
        }
        return this.newReaderBr(fileType + "Reader", br);
    }

    Object getReaderData() {
        Object o = this.readerData;
        this.readerData = null;
        return o;
    }

    void initializeIsosurface() {
        this.params.initialize();
        this.colorPtr = 0;
        this.surfaceReader = null;
        this.marchingSquares = null;
        this.initState();
    }

    public void initState() {
        this.params.state = 1;
        this.params.surfaceType = 0;
        this.params.dataType = 0;
    }

    public String setLcao() {
        this.params.colorPos = this.params.colorPosLCAO;
        this.params.colorNeg = this.params.colorNegLCAO;
        return this.params.lcaoType;
    }

    private void getFunctionZfromXY() {
        P3 origin = (P3)this.params.functionInfo.get(1);
        int[] counts = new int[3];
        int[] nearest = new int[3];
        V3[] vectors = new V3[3];
        for (int i = 0; i < 3; ++i) {
            P4 info = (P4)this.params.functionInfo.get(i + 2);
            counts[i] = Math.abs((int)info.x);
            vectors[i] = V3.new3((float)info.y, (float)info.z, (float)info.w);
        }
        int nx = counts[0];
        int ny = counts[1];
        P3 pt = new P3();
        P3 pta = new P3();
        P3 ptb = new P3();
        P3 ptc = new P3();
        float[][] data = (float[][])this.params.functionInfo.get(5);
        float[][] data2 = new float[nx][ny];
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                pt.scaleAdd2((float)i, (T3)vectors[0], (T3)origin);
                pt.scaleAdd2((float)j, (T3)vectors[1], (T3)pt);
                float dist = SurfaceGenerator.findNearestThreePoints(pt.x, pt.y, data, nearest);
                float[] d = data[nearest[0]];
                pta.set(d[0], d[1], d[2]);
                if ((double)dist < 1.0E-5) {
                    pt.z = d[2];
                } else {
                    d = data[nearest[1]];
                    ptb.set(d[0], d[1], d[2]);
                    d = data[nearest[2]];
                    ptc.set(d[0], d[1], d[2]);
                    pt.z = this.distanceVerticalToPlane(pt.x, pt.y, pta, ptb, ptc);
                }
                data2[i][j] = pt.z;
            }
        }
        this.params.functionInfo.set(5, (Object)data2);
    }

    private float distanceVerticalToPlane(float x, float y, P3 pta, P3 ptb, P3 ptc) {
        float d = Measure.getDirectedNormalThroughPoints((T3)pta, (T3)ptb, (T3)ptc, (T3)this.ptRef, (V3)this.vNorm, (V3)this.vAB);
        return (this.vNorm.x * x + this.vNorm.y * y + d) / -this.vNorm.z;
    }

    private static float findNearestThreePoints(float x, float y, float[][] xyz, int[] result) {
        int i3 = -1;
        int i2 = -1;
        int i1 = -1;
        float dist3 = Float.MAX_VALUE;
        float dist2 = Float.MAX_VALUE;
        float dist1 = Float.MAX_VALUE;
        int i = xyz.length;
        while (--i >= 0) {
            float d = xyz[i][0] - x;
            float f = d * d;
            d = xyz[i][1] - y;
            if ((d = f + d * d) < dist1) {
                dist3 = dist2;
                dist2 = dist1;
                dist1 = d;
                i3 = i2;
                i2 = i1;
                i1 = i;
                continue;
            }
            if (d < dist2) {
                dist3 = dist2;
                dist2 = d;
                i3 = i2;
                i2 = i;
                continue;
            }
            if (!(d < dist3)) continue;
            dist3 = d;
            i3 = i;
        }
        result[0] = i1;
        result[1] = i2;
        result[2] = i3;
        return dist1;
    }

    public void addRequiredFile(String fileName) {
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.addRequiredFile(fileName);
    }

    void log(String msg) {
        if (this.atomDataServer == null) {
            System.out.println(msg);
        } else {
            this.atomDataServer.log(msg);
        }
    }

    void setOutputChannel(GenericBinaryDocument binaryDoc, OC out) {
        if (this.meshDataServer == null) {
            return;
        }
        this.meshDataServer.setOutputChannel(binaryDoc, out);
    }

    void fillAtomData(AtomData atomData, int mode) {
        if ((mode & 2) != 0 && atomData.bsSelected != null) {
            if (this.bsVdw == null) {
                this.bsVdw = new BS();
            }
            this.bsVdw.or(atomData.bsSelected);
        }
        this.atomDataServer.fillAtomData(atomData, mode);
    }

    public V3[] getSpanningVectors() {
        return this.surfaceReader.volumeData == null ? null : this.surfaceReader.volumeData.spanningVectors;
    }
}

