/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;

class XsfReader
extends VolumeFileReader {
    private boolean isBXSF = false;

    XsfReader() {
    }

    @Override
    void init2(SurfaceGenerator sg, BufferedReader br) {
        this.init2VFR(sg, br);
    }

    @Override
    protected void readParameters() throws Exception {
        this.isAngstroms = false;
        this.params.blockCubeData = true;
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("XsfReader file\n");
        boolean needCutoff = this.params.cutoffAutomatic;
        this.isAngstroms = true;
        String beginKey = "BEGIN_DATAGRID_3D";
        this.nSurfaces = 1;
        while (this.rd() != null && this.line.indexOf(beginKey) < 0) {
            Logger.info((String)this.line);
            if (this.line.indexOf("Fermi Energy:") < 0) continue;
            this.isBXSF = true;
            beginKey = "BEGIN_BANDGRID_3D";
            if (!needCutoff) continue;
            this.params.cutoff = this.parseFloatStr(this.getTokens()[2]);
            needCutoff = false;
        }
        if (needCutoff) {
            this.params.cutoff = 0.05f;
        }
        if (this.isBXSF) {
            this.nSurfaces = this.parseIntStr(this.rd());
        }
        this.voxelCounts[0] = this.parseIntStr(this.rd());
        this.voxelCounts[1] = this.parseInt();
        this.voxelCounts[2] = this.parseInt();
        this.volumetricOrigin.set(this.parseFloatStr(this.rd()), this.parseFloat(), this.parseFloat());
        for (int i = 0; i < 3; ++i) {
            this.volumetricVectors[i].set(this.parseFloatStr(this.rd()), this.parseFloat(), this.parseFloat());
            this.volumetricVectors[i].scale(1.0f / (float)(this.voxelCounts[i] - 1));
        }
        if (!this.isBXSF) {
            this.swapXZ();
        }
    }

    @Override
    protected void gotoData(int n, int nPoints) throws Exception {
        if (!this.params.blockCubeData) {
            return;
        }
        if (n > 0) {
            Logger.info((String)("skipping " + n + " data sets, " + nPoints + " points each"));
        }
        if (this.isBXSF) {
            Logger.info((String)this.rd());
        }
        for (int i = 0; i < n; ++i) {
            this.skipData(nPoints);
        }
    }

    @Override
    protected void skipData(int nPoints) throws Exception {
        this.skipDataVFR(nPoints);
        if (this.isBXSF) {
            Logger.info((String)this.rd());
        }
    }
}

