/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.GaussianReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class GaussianFchkReader
extends GaussianReader {
    private Map<String, Object> fileData;
    private int atomCount;
    private static String[] AO_TYPES = new String[]{"F7", "D5", "L", "S", "P", "D", "F", "G", "H"};

    @Override
    protected void initializeReader() throws Exception {
        super.initializeReader();
        this.energyUnits = "";
        this.fileData = new Hashtable<String, Object>();
        this.fileData.put("title", this.rd().trim());
        this.calculationType = PT.rep(this.rd(), "  ", " ");
        this.asc.newAtomSet();
        this.asc.setCurrentModelInfo("fileData", this.fileData);
        this.readAllData();
        this.readAtoms();
        this.readBonds();
        this.readDipoleMoment();
        this.readPartialCharges();
        this.readBasis();
        this.readMolecularObitals();
        this.checkForFreq();
        this.continuing = false;
    }

    private void checkForFreq() throws Exception {
        Integer n = (Integer)this.fileData.get("Vib-NDim");
        if (n == null) {
            this.readFrequencies("NumFreq", false);
            return;
        }
        try {
            int nModes = n;
            float[] vibE2 = (float[])this.fileData.get("Vib-E2");
            float[] modes = (float[])this.fileData.get("Vib-Modes");
            float[] frequencies = this.fillFloat(vibE2, 0, nModes);
            float[] red_masses = this.fillFloat(vibE2, nModes, nModes);
            float[] frc_consts = this.fillFloat(vibE2, nModes * 2, nModes);
            float[] intensities = this.fillFloat(vibE2, nModes * 3, nModes);
            int ac = this.asc.getLastAtomSetAtomCount();
            boolean[] ignore = new boolean[nModes];
            int fpt = 0;
            for (int i = 0; i < nModes; ++i) {
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                int iAtom0 = this.asc.ac;
                this.asc.cloneAtomSetWithBonds(true);
                String name = this.asc.setAtomSetFrequency("Calculation " + this.calculationNumber, null, "" + frequencies[i], null);
                this.appendLoadNote("model " + this.asc.atomSetCount + ": " + name);
                this.namedSets.set(this.asc.iSet);
                this.asc.setAtomSetModelProperty("ReducedMass", red_masses[i] + " AMU");
                this.asc.setAtomSetModelProperty("ForceConstant", frc_consts[i] + " mDyne/A");
                this.asc.setAtomSetModelProperty("IRIntensity", intensities[i] + " KM/Mole");
                for (int iAtom = 0; iAtom < ac; ++iAtom) {
                    this.asc.addVibrationVectorWithSymmetry(iAtom0 + iAtom, modes[fpt++], modes[fpt++], modes[fpt++], false);
                }
            }
        }
        catch (Exception e) {
            Logger.error("Could not read Vib-E2 section: " + e.getMessage());
        }
    }

    private float[] fillFloat(float[] f0, int i, int n) {
        float[] f = new float[n];
        int i1 = 0;
        int ilast = i + n;
        while (i < ilast) {
            f[i1] = f0[i];
            ++i;
            ++i1;
        }
        return f;
    }

    private void readAllData() throws Exception {
        while ((this.line == null ? this.rd() : this.line) != null) {
            if (this.line.length() < 40) {
                if (this.line.indexOf("NumAtom") != 0) continue;
                return;
            }
            String name = PT.rep(this.line.substring(0, 40).trim(), " ", "");
            char type = this.line.charAt(43);
            boolean isArray = this.line.indexOf("N=") >= 0;
            String v = this.line.substring(50).trim();
            Logger.info(name + " = " + v + " " + isArray);
            Object o = null;
            if (isArray) {
                switch (type) {
                    case 'I': 
                    case 'R': {
                        o = this.fillFloatArray(null, 0, new float[this.parseIntStr(v)]);
                        this.line = null;
                        break;
                    }
                    default: {
                        v = this.rd().trim();
                        while (this.rd() != null && this.line.indexOf("   N=   ") < 0) {
                            v = v + " " + this.line.trim();
                        }
                        o = v;
                        break;
                    }
                }
            } else {
                switch (type) {
                    case 'I': {
                        o = this.parseIntStr(v);
                        break;
                    }
                    case 'R': {
                        o = Double.parseDouble(v);
                        break;
                    }
                    case 'C': 
                    case 'L': {
                        o = v;
                    }
                }
                this.line = null;
            }
            if (o == null) continue;
            this.fileData.put(name, o);
        }
    }

    @Override
    protected void readAtoms() throws Exception {
        float[] atomNumbers = (float[])this.fileData.get("Atomicnumbers");
        float[] data = (float[])this.fileData.get("Currentcartesiancoordinates");
        String e = "" + this.fileData.get("TotalEnergy");
        this.asc.setAtomSetEnergy(e, this.parseFloatStr(e));
        this.atomCount = atomNumbers.length;
        float f = 0.5291772f;
        int pt = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atom = this.asc.addNewAtom();
            atom.elementNumber = (short)atomNumbers[i];
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            this.setAtomCoordXYZ(atom, data[pt++] * f, data[pt++] * f, data[pt++] * f);
        }
    }

    protected void readBonds() {
        try {
            float[] nBond = (float[])this.fileData.get("NBond");
            float[] iBond = (float[])this.fileData.get("IBond");
            if (nBond.length == 0) {
                return;
            }
            float[] rBond = (float[])this.fileData.get("RBond");
            int mxBond = rBond.length / nBond.length;
            int pt = 0;
            for (int ia = 0; ia < this.atomCount; ++ia) {
                int j = 0;
                while (j < mxBond) {
                    int ib = (int)iBond[pt] - 1;
                    if (ib > ia) {
                        float order = rBond[pt];
                        int iorder = order == 1.5f ? 515 : (int)order;
                        this.asc.addBond(new Bond(ia, ib, iorder));
                    }
                    ++j;
                    ++pt;
                }
            }
            this.addJmolScript("connect 1.1 {_H} {*} ");
        }
        catch (Exception e) {
            Logger.info("GaussianFchkReader -- bonding ignored");
        }
    }

    @Override
    protected void readDipoleMoment() throws Exception {
        float[] data = (float[])this.fileData.get("DipoleMoment");
        if (data == null) {
            return;
        }
        V3 dipole = V3.new3(data[0], data[1], data[2]);
        Logger.info("Molecular dipole for model " + this.asc.atomSetCount + " = " + dipole);
        this.asc.setCurrentModelInfo("dipole", dipole);
    }

    @Override
    protected void readPartialCharges() throws Exception {
        float[] data = (float[])this.fileData.get("Mulliken Charges");
        if (data == null) {
            return;
        }
        Atom[] atoms = this.asc.atoms;
        for (int i = 0; i < this.atomCount; ++i) {
            float c;
            atoms[i].partialCharge = c = data[i];
            if (!(Math.abs(c) > 0.8f)) continue;
            atoms[i].formalCharge = Math.round(c);
        }
        Logger.info("Mulliken charges found for Model " + this.asc.atomSetCount);
    }

    @Override
    protected void readBasis() throws Exception {
        float[] types = (float[])this.fileData.get("Shelltypes");
        this.gaussianCount = 0;
        this.shellCount = 0;
        if (types == null) {
            return;
        }
        this.shellCount = types.length;
        this.shells = new Lst();
        float[] pps = (float[])this.fileData.get("Numberofprimitivespershell");
        float[] atomMap = (float[])this.fileData.get("Shelltoatommap");
        float[] exps = (float[])this.fileData.get("Primitiveexponents");
        float[] coefs = (float[])this.fileData.get("Contractioncoefficients");
        float[] spcoefs = (float[])this.fileData.get("P(S=P)Contractioncoefficients");
        this.gaussians = AU.newFloat2(exps.length);
        for (int i = 0; i < this.shellCount; ++i) {
            String oType = AO_TYPES[(int)types[i] + 3];
            int nGaussians = (int)pps[i];
            int iatom = (int)atomMap[i];
            int[] slater = new int[]{iatom - 1, oType.equals("F7") || oType.equals("D5") ? BasisFunctionReader.getQuantumShellTagIDSpherical(oType.substring(0, 1)) : BasisFunctionReader.getQuantumShellTagID(oType), this.gaussianCount, nGaussians};
            if (this.debugging) {
                Logger.debug("Slater " + this.shells.size() + " " + Escape.eAI(slater));
            }
            this.shells.addLast(slater);
            for (int j = 0; j < nGaussians; ++j) {
                this.gaussians[this.gaussianCount] = new float[3];
                float[] g = this.gaussians[this.gaussianCount];
                g[0] = exps[this.gaussianCount];
                g[1] = coefs[this.gaussianCount];
                if (spcoefs != null) {
                    g[2] = spcoefs[this.gaussianCount];
                }
                ++this.gaussianCount;
            }
        }
        Logger.info(this.shellCount + " slater shells read");
        Logger.info(this.gaussianCount + " gaussian primitives read");
    }

    protected void readMolecularObitals() throws Exception {
        if (this.shells == null) {
            return;
        }
        int nElec = (Integer)this.fileData.get("Numberofelectrons");
        int nAlpha = (Integer)this.fileData.get("Numberofalphaelectrons");
        int nBeta = (Integer)this.fileData.get("Numberofbetaelectrons");
        float[] aenergies = (float[])this.fileData.get("AlphaOrbitalEnergies");
        float[] benergies = (float[])this.fileData.get("BetaOrbitalEnergies");
        float[] acoefs = (float[])this.fileData.get("AlphaMOcoefficients");
        float[] bcoefs = (float[])this.fileData.get("BetaMOcoefficients");
        if (acoefs == null) {
            return;
        }
        int occ = bcoefs == null ? 2 : 1;
        int n = bcoefs == null ? nElec : nAlpha;
        this.getOrbitals(aenergies, acoefs, occ, n);
        if (bcoefs != null) {
            this.getOrbitals(benergies, bcoefs, occ, nBeta);
        }
        this.setMOData(false);
    }

    private void getOrbitals(float[] e, float[] c, int occ, int nElec) {
        int nOrb = e.length;
        int nCoef = c.length;
        nCoef /= nOrb;
        this.alphaBeta = occ == 2 ? "" : (this.alphaBeta.equals("alpha") ? "beta" : "alpha");
        int pt = 0;
        int n = 0;
        for (int i = 0; i < nOrb; ++i) {
            float[] coefs = new float[nCoef];
            for (int j = 0; j < nCoef; ++j) {
                coefs[j] = c[pt++];
            }
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("coefficients", coefs);
            mo.put("occupancy", Float.valueOf(occ));
            if ((n += occ) >= nElec) {
                occ = 0;
            }
            mo.put("energy", Float.valueOf(e[i]));
            mo.put("type", this.alphaBeta);
            this.setMO(mo);
        }
    }
}

