/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.PrintStream;
import java.io.PrintWriter;

public class CompoundException
extends Exception {
    private static final long serialVersionUID = -9207883813472069925L;
    @Nullable
    private final Throwable _innerException;

    public CompoundException(@Nullable String string) {
        this(string, null);
    }

    public CompoundException(@Nullable Throwable throwable) {
        this(null, throwable);
    }

    public CompoundException(@Nullable String string, @Nullable Throwable throwable) {
        super(string);
        this._innerException = throwable;
    }

    @Nullable
    public Throwable getInnerException() {
        return this._innerException;
    }

    @Override
    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (this._innerException != null) {
            stringBuilder.append("\n");
            stringBuilder.append("--- inner exception ---");
            stringBuilder.append("\n");
            stringBuilder.append(this._innerException.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void printStackTrace(@NotNull PrintStream printStream) {
        super.printStackTrace(printStream);
        if (this._innerException != null) {
            printStream.println("--- inner exception ---");
            this._innerException.printStackTrace(printStream);
        }
    }

    @Override
    public void printStackTrace(@NotNull PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        if (this._innerException != null) {
            printWriter.println("--- inner exception ---");
            this._innerException.printStackTrace(printWriter);
        }
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        if (this._innerException != null) {
            System.err.println("--- inner exception ---");
            this._innerException.printStackTrace();
        }
    }
}

