/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;

public class ImmutableGpxTrackSegment
implements GpxTrackSegment {
    private final List<WayPoint> wayPoints;
    private final Bounds bounds;
    private final double length;

    public ImmutableGpxTrackSegment(Collection<WayPoint> collection) {
        this.wayPoints = Collections.unmodifiableList(new ArrayList<WayPoint>(collection));
        this.bounds = this.calculateBounds();
        this.length = this.calculateLength();
    }

    private Bounds calculateBounds() {
        Bounds bounds = null;
        for (WayPoint wayPoint : this.wayPoints) {
            if (bounds == null) {
                bounds = new Bounds(wayPoint.getCoor());
                continue;
            }
            bounds.extend(wayPoint.getCoor());
        }
        return bounds;
    }

    private double calculateLength() {
        double d = 0.0;
        WayPoint wayPoint = null;
        for (WayPoint wayPoint2 : this.wayPoints) {
            Double d2;
            if (wayPoint != null && !(d2 = Double.valueOf(wayPoint.getCoor().greatCircleDistance(wayPoint2.getCoor()))).isNaN() && !d2.isInfinite()) {
                d += d2.doubleValue();
            }
            wayPoint = wayPoint2;
        }
        return d;
    }

    @Override
    public Bounds getBounds() {
        return this.bounds == null ? null : new Bounds(this.bounds);
    }

    @Override
    public Collection<WayPoint> getWayPoints() {
        return Collections.unmodifiableList(this.wayPoints);
    }

    @Override
    public double length() {
        return this.length;
    }

    @Override
    public int getUpdateCount() {
        return 0;
    }

    public int hashCode() {
        return 31 + (this.wayPoints == null ? 0 : this.wayPoints.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImmutableGpxTrackSegment immutableGpxTrackSegment = (ImmutableGpxTrackSegment)object;
        return !(this.wayPoints == null ? immutableGpxTrackSegment.wayPoints != null : !this.wayPoints.equals(immutableGpxTrackSegment.wayPoints));
    }
}

