/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.DoubleUnaryOperator;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ShiftedProjecting;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractProjection
implements Projection {
    protected Ellipsoid ellps;
    protected Datum datum;
    protected Proj proj;
    protected double x0;
    protected double y0;
    protected double lon0;
    protected double pm;
    protected double k0 = 1.0;
    protected double toMeter = 1.0;
    private volatile ProjectionBounds projectionBoundsBox;

    public final Ellipsoid getEllipsoid() {
        return this.ellps;
    }

    public final Datum getDatum() {
        return this.datum;
    }

    public final Proj getProj() {
        return this.proj;
    }

    public final double getFalseEasting() {
        return this.x0;
    }

    public final double getFalseNorthing() {
        return this.y0;
    }

    public final double getCentralMeridian() {
        return this.lon0;
    }

    public final double getScaleFactor() {
        return this.k0;
    }

    public final double getToMeter() {
        return this.toMeter;
    }

    @Override
    public EastNorth latlon2eastNorth(ILatLon iLatLon) {
        LatLon latLon = this.datum.fromWGS84(new LatLon(iLatLon));
        double[] dArray = this.proj.project(Utils.toRadians(latLon.lat()), Utils.toRadians(LatLon.normalizeLon(latLon.lon() - this.lon0 - this.pm)));
        return new EastNorth((this.ellps.a * this.k0 * dArray[0] + this.x0) / this.toMeter, (this.ellps.a * this.k0 * dArray[1] + this.y0) / this.toMeter);
    }

    @Override
    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        return this.eastNorth2latlon(eastNorth, LatLon::normalizeLon);
    }

    @Override
    public LatLon eastNorth2latlonClamped(EastNorth eastNorth) {
        LatLon latLon = this.eastNorth2latlon(eastNorth, d -> Utils.clamp(d, -180.0, 180.0));
        Bounds bounds = this.getWorldBoundsLatLon();
        return new LatLon(Utils.clamp(latLon.lat(), bounds.getMinLat(), bounds.getMaxLat()), Utils.clamp(latLon.lon(), bounds.getMinLon(), bounds.getMaxLon()));
    }

    private LatLon eastNorth2latlon(EastNorth eastNorth, DoubleUnaryOperator doubleUnaryOperator) {
        double[] dArray = this.proj.invproject((eastNorth.east() * this.toMeter - this.x0) / this.ellps.a / this.k0, (eastNorth.north() * this.toMeter - this.y0) / this.ellps.a / this.k0);
        double d = Utils.toDegrees(dArray[1]) + this.lon0 + this.pm;
        LatLon latLon = new LatLon(Utils.toDegrees(dArray[0]), doubleUnaryOperator.applyAsDouble(d));
        return this.datum.toWGS84(latLon);
    }

    @Override
    public Map<ProjectionBounds, Projecting> getProjectingsForArea(ProjectionBounds projectionBounds) {
        if (this.proj.lonIsLinearToEast()) {
            Bounds bounds = this.getWorldBoundsLatLon();
            double d = this.latlon2eastNorth(bounds.getMin()).east();
            double d2 = this.latlon2eastNorth(bounds.getMax()).east();
            double d3 = d2 - d;
            if ((projectionBounds.minEast < d || projectionBounds.maxEast > d2) && d3 > 0.0) {
                int n = (int)Math.floor((projectionBounds.minEast - d) / d3);
                int n2 = (int)Math.floor((projectionBounds.maxEast - d) / d3);
                HashMap<ProjectionBounds, Projecting> hashMap = new HashMap<ProjectionBounds, Projecting>();
                for (int i = n; i <= n2; ++i) {
                    hashMap.put(new ProjectionBounds(Math.max(projectionBounds.minEast, d + (double)i * d3), projectionBounds.minNorth, Math.min(projectionBounds.maxEast, d2 + (double)i * d3), projectionBounds.maxNorth), new ShiftedProjecting(this, new EastNorth((double)(-i) * d3, 0.0)));
                }
                return hashMap;
            }
        }
        return Collections.singletonMap(projectionBounds, this);
    }

    @Override
    public double getDefaultZoomInPPD() {
        return 10.0 / this.getMetersPerUnit();
    }

    public abstract Integer getEpsgCode();

    @Override
    public String toCode() {
        return "EPSG:" + this.getEpsgCode();
    }

    protected static final double convertMinuteSecond(double d, double d2) {
        return d / 60.0 + d2 / 3600.0;
    }

    protected static final double convertDegreeMinuteSecond(double d, double d2, double d3) {
        return d + d2 / 60.0 + d3 / 3600.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ProjectionBounds getWorldBoundsBoxEastNorth() {
        ProjectionBounds projectionBounds = this.projectionBoundsBox;
        if (projectionBounds == null) {
            AbstractProjection abstractProjection = this;
            synchronized (abstractProjection) {
                projectionBounds = this.projectionBoundsBox;
                if (projectionBounds == null) {
                    double d;
                    Bounds bounds = this.getWorldBoundsLatLon();
                    projectionBounds = new ProjectionBounds(this.latlon2eastNorth(bounds.getMin()));
                    projectionBounds.extend(this.latlon2eastNorth(bounds.getMax()));
                    projectionBounds.extend(this.latlon2eastNorth(new LatLon(bounds.getMinLat(), bounds.getMaxLon())));
                    projectionBounds.extend(this.latlon2eastNorth(new LatLon(bounds.getMaxLat(), bounds.getMinLon())));
                    double d2 = (bounds.getMaxLon() - bounds.getMinLon()) / 1000.0;
                    double d3 = (bounds.getMaxLat() - bounds.getMinLat()) / 1000.0;
                    for (d = bounds.getMinLon(); d < bounds.getMaxLon(); d += d2) {
                        projectionBounds.extend(this.latlon2eastNorth(new LatLon(bounds.getMinLat(), d)));
                        projectionBounds.extend(this.latlon2eastNorth(new LatLon(bounds.getMaxLat(), d)));
                    }
                    for (d = bounds.getMinLat(); d < bounds.getMaxLat(); d += d3) {
                        projectionBounds.extend(this.latlon2eastNorth(new LatLon(d, bounds.getMinLon())));
                        projectionBounds.extend(this.latlon2eastNorth(new LatLon(d, bounds.getMaxLon())));
                    }
                    this.projectionBoundsBox = projectionBounds;
                }
            }
        }
        return this.projectionBoundsBox;
    }

    @Override
    public Projection getBaseProjection() {
        return this;
    }
}

