/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class Lanes
extends Test.TagTest {
    private static final String[] BLACKLIST = new String[]{"source:lanes", "note:lanes", "proposed:lanes", "piste:lanes"};

    public Lanes() {
        super(I18n.tr("Lane tags", new Object[0]), I18n.tr("Test that validates ''lane:'' tags.", new Object[0]));
    }

    static int getLanesCount(String string) {
        return string.isEmpty() ? 0 : string.replaceAll("[^|]", "").length() + 1;
    }

    protected void checkNumberOfLanesByKey(OsmPrimitive osmPrimitive, String string3, String string4) {
        Set set = osmPrimitive.keySet().stream().filter(string2 -> string2.endsWith(":" + string3)).filter(string -> !Arrays.asList(BLACKLIST).contains(string)).map(string -> Lanes.getLanesCount(osmPrimitive.get((String)string))).collect(Collectors.toSet());
        if (set.size() > 1) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 3100).message(string4).primitives(osmPrimitive).build());
        } else if (set.size() == 1 && osmPrimitive.hasKey(string3)) {
            try {
                if (Integer.parseInt(osmPrimitive.get(string3)) > (Integer)set.iterator().next()) {
                    this.errors.add(TestError.builder(this, Severity.WARNING, 3100).message(I18n.tr("Number of {0} greater than {1}", string3, "*:" + string3)).primitives(osmPrimitive).build());
                }
            }
            catch (NumberFormatException numberFormatException) {
                Main.debug(numberFormatException.getMessage());
            }
        }
    }

    protected void checkNumberOfLanes(OsmPrimitive osmPrimitive) {
        String string = osmPrimitive.get("lanes");
        if (string == null) {
            return;
        }
        String string2 = Utils.firstNonNull(osmPrimitive.get("lanes:forward"), "0");
        String string3 = Utils.firstNonNull(osmPrimitive.get("lanes:backward"), "0");
        try {
            if (Integer.parseInt(string) < Integer.parseInt(string2) + Integer.parseInt(string3)) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 3101).message(I18n.tr("Number of {0} greater than {1}", I18n.tr("{0}+{1}", "lanes:forward", "lanes:backward"), "lanes")).primitives(osmPrimitive).build());
            }
        }
        catch (NumberFormatException numberFormatException) {
            Main.debug(numberFormatException.getMessage());
        }
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        this.checkNumberOfLanesByKey(osmPrimitive, "lanes", I18n.tr("Number of lane dependent values inconsistent", new Object[0]));
        this.checkNumberOfLanesByKey(osmPrimitive, "lanes:forward", I18n.tr("Number of lane dependent values inconsistent in forward direction", new Object[0]));
        this.checkNumberOfLanesByKey(osmPrimitive, "lanes:backward", I18n.tr("Number of lane dependent values inconsistent in backward direction", new Object[0]));
        this.checkNumberOfLanes(osmPrimitive);
    }
}

