/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.ChangePropertyKeyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.gui.mappaint.mapcss.ConditionFactory;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSRule;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.Selector;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.MapCSSParser;
import org.openstreetmap.josm.gui.mappaint.mapcss.parsergen.ParseException;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorTagCheckerRulesPreference;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public class MapCSSTagChecker
extends Test.TagTest {
    public static final String ENTRIES_PREF_KEY = "validator." + MapCSSTagChecker.class.getName() + ".entries";
    final MultiMap<String, TagCheck> checks = new MultiMap();

    public MapCSSTagChecker() {
        super(I18n.tr("Tag checker (MapCSS based)", new Object[0]), I18n.tr("This test checks for errors in tag keys and values.", new Object[0]));
    }

    public synchronized Collection<TestError> getErrorsForPrimitive(OsmPrimitive osmPrimitive, boolean bl) {
        return MapCSSTagChecker.getErrorsForPrimitive(osmPrimitive, bl, this.checks.values());
    }

    private static Collection<TestError> getErrorsForPrimitive(OsmPrimitive osmPrimitive, boolean bl, Collection<Set<TagCheck>> collection) {
        ArrayList<TestError> arrayList = new ArrayList<TestError>();
        Environment environment = new Environment(osmPrimitive, new MultiCascade(), "default", null);
        for (Set<TagCheck> set : collection) {
            for (TagCheck tagCheck : set) {
                Selector selector;
                if (Severity.OTHER.equals((Object)tagCheck.getSeverity()) && !bl || (selector = tagCheck.whichSelectorMatchesEnvironment(environment)) == null) continue;
                tagCheck.rule.declaration.execute(environment);
                TestError testError = tagCheck.getErrorForPrimitive(osmPrimitive, selector, environment, new MapCSSTagCheckerAndRule(tagCheck.rule));
                if (testError == null) continue;
                arrayList.add(testError);
            }
        }
        return arrayList;
    }

    @Override
    public void check(OsmPrimitive osmPrimitive) {
        this.errors.addAll(this.getErrorsForPrimitive(osmPrimitive, ValidatorPreference.PREF_OTHER.get()));
    }

    public synchronized ParseResult addMapCSS(String string) throws ParseException, IOException {
        ParseResult parseResult;
        CheckParameterUtil.ensureParameterNotNull(string, "url");
        try (CachedFile cachedFile = new CachedFile(string);
             InputStream inputStream = cachedFile.findZipEntryInputStream("validator.mapcss", "");
             InputStream inputStream2 = inputStream != null ? inputStream : cachedFile.getInputStream();
             BufferedReader bufferedReader = new BufferedReader(UTFInputStreamReader.create(inputStream2));){
            parseResult = TagCheck.readMapCSS(bufferedReader);
            this.checks.remove(string);
            this.checks.putAll(string, parseResult.parseChecks);
            if (Main.pref.getBoolean("validator.check_assert_local_rules", false) && Utils.isLocalUrl(string)) {
                for (String string2 : this.checkAsserts(parseResult.parseChecks)) {
                    Main.warn(string2);
                }
            }
        }
        return parseResult;
    }

    @Override
    public synchronized void initialize() throws Exception {
        this.checks.clear();
        for (SourceEntry sourceEntry : new ValidatorTagCheckerRulesPreference.RulePrefHelper().get()) {
            if (!sourceEntry.active) continue;
            String string = sourceEntry.url;
            try {
                if (!string.startsWith("resource:")) {
                    Main.info(I18n.tr("Adding {0} to tag checker", string));
                } else if (Main.isDebugEnabled()) {
                    Main.debug(I18n.tr("Adding {0} to tag checker", string));
                }
                this.addMapCSS(string);
                if (!Main.pref.getBoolean("validator.auto_reload_local_rules", true) || !sourceEntry.isLocal()) continue;
                Main.fileWatcher.registerValidatorRule(sourceEntry);
            }
            catch (IOException | IllegalStateException exception) {
                Main.warn(I18n.tr("Failed to add {0} to tag checker", string));
                Main.warn((Throwable)exception, false);
            }
            catch (ParseException parseException) {
                Main.warn(I18n.tr("Failed to add {0} to tag checker", string));
                Main.warn(parseException);
            }
        }
    }

    public Set<String> checkAsserts(Collection<TagCheck> collection) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        DataSet dataSet = new DataSet();
        for (TagCheck tagCheck : collection) {
            if (Main.isDebugEnabled()) {
                Main.debug("Check: " + tagCheck);
            }
            for (Map.Entry<String, Boolean> entry : tagCheck.assertions.entrySet()) {
                boolean bl;
                if (Main.isDebugEnabled()) {
                    Main.debug("- Assertion: " + entry);
                }
                OsmPrimitive osmPrimitive = OsmUtils.createPrimitive(entry.getKey());
                ArrayList<Set<TagCheck>> arrayList = new ArrayList<Set<TagCheck>>();
                Set<TagCheck> set = tagCheck.getTagCheckDependencies(collection);
                if (!set.isEmpty()) {
                    arrayList.add(set);
                }
                arrayList.add(Collections.singleton(tagCheck));
                dataSet.addPrimitive(osmPrimitive);
                Collection<TestError> collection2 = MapCSSTagChecker.getErrorsForPrimitive(osmPrimitive, true, arrayList);
                if (Main.isDebugEnabled()) {
                    Main.debug("- Errors: " + collection2);
                }
                if ((bl = collection2.stream().anyMatch(testError -> testError.getTester().equals(tagCheck.rule))) != entry.getValue()) {
                    String string = MessageFormat.format("Expecting test ''{0}'' (i.e., {1}) to {2} {3} (i.e., {4})", tagCheck.getMessage(osmPrimitive), tagCheck.rule.selectors, entry.getValue() != false ? "match" : "not match", entry.getKey(), osmPrimitive.getKeys());
                    linkedHashSet.add(string);
                }
                dataSet.removePrimitive((PrimitiveId)osmPrimitive);
            }
        }
        return linkedHashSet;
    }

    @Override
    public synchronized int hashCode() {
        return Objects.hash(super.hashCode(), this.checks);
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MapCSSTagChecker mapCSSTagChecker = (MapCSSTagChecker)object;
        return Objects.equals(this.checks, mapCSSTagChecker.checks);
    }

    static class MapCSSTagCheckerAndRule
    extends MapCSSTagChecker {
        public final GroupedMapCSSRule rule;

        MapCSSTagCheckerAndRule(GroupedMapCSSRule groupedMapCSSRule) {
            this.rule = groupedMapCSSRule;
        }

        @Override
        public synchronized boolean equals(Object object) {
            return super.equals(object) || object instanceof TagCheck && this.rule.equals(((TagCheck)object).rule) || object instanceof GroupedMapCSSRule && this.rule.equals(object);
        }

        @Override
        public synchronized int hashCode() {
            return Objects.hash(super.hashCode(), this.rule);
        }

        public String toString() {
            return "MapCSSTagCheckerAndRule [rule=" + this.rule + ']';
        }
    }

    public static class TagCheck
    implements Predicate<OsmPrimitive> {
        protected final GroupedMapCSSRule rule;
        protected final List<FixCommand> fixCommands = new ArrayList<FixCommand>();
        protected final List<String> alternatives = new ArrayList<String>();
        protected final Map<Instruction.AssignmentInstruction, Severity> errors = new HashMap<Instruction.AssignmentInstruction, Severity>();
        protected final Map<String, Boolean> assertions = new HashMap<String, Boolean>();
        protected final Set<String> setClassExpressions = new HashSet<String>();
        protected boolean deletion;
        protected String group;
        private static final String POSSIBLE_THROWS = TagCheck.possibleThrows();

        TagCheck(GroupedMapCSSRule groupedMapCSSRule) {
            this.rule = groupedMapCSSRule;
        }

        static final String possibleThrows() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Severity severity : Severity.values()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('/');
                }
                stringBuilder.append("throw").append(severity.name().charAt(0)).append(severity.name().substring(1).toLowerCase(Locale.ENGLISH));
            }
            return stringBuilder.toString();
        }

        static TagCheck ofMapCSSRule(GroupedMapCSSRule groupedMapCSSRule) throws IllegalDataException {
            TagCheck tagCheck = new TagCheck(groupedMapCSSRule);
            for (Instruction instruction : groupedMapCSSRule.declaration.instructions) {
                if (!(instruction instanceof Instruction.AssignmentInstruction)) continue;
                Instruction.AssignmentInstruction assignmentInstruction = (Instruction.AssignmentInstruction)instruction;
                if (assignmentInstruction.isSetInstruction) {
                    tagCheck.setClassExpressions.add(assignmentInstruction.key);
                    continue;
                }
                try {
                    String string;
                    String string2 = assignmentInstruction.val instanceof Expression ? (String)((Expression)assignmentInstruction.val).evaluate(new Environment()) : (assignmentInstruction.val instanceof String ? (String)assignmentInstruction.val : (string = assignmentInstruction.val instanceof Keyword ? ((Keyword)assignmentInstruction.val).val : null));
                    if (assignmentInstruction.key.startsWith("throw")) {
                        try {
                            tagCheck.errors.put(assignmentInstruction, Severity.valueOf(assignmentInstruction.key.substring("throw".length()).toUpperCase(Locale.ENGLISH)));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Main.warn((Throwable)illegalArgumentException, "Unsupported " + assignmentInstruction.key + " instruction. Allowed instructions are " + POSSIBLE_THROWS + '.');
                        }
                        continue;
                    }
                    if ("fixAdd".equals(assignmentInstruction.key)) {
                        tagCheck.fixCommands.add(FixCommand.fixAdd(assignmentInstruction.val));
                        continue;
                    }
                    if ("fixRemove".equals(assignmentInstruction.key)) {
                        CheckParameterUtil.ensureThat(!(assignmentInstruction.val instanceof String) || string == null || !string.contains("="), "Unexpected '='. Please only specify the key to remove!");
                        tagCheck.fixCommands.add(FixCommand.fixRemove(assignmentInstruction.val));
                        continue;
                    }
                    if (string != null && "fixChangeKey".equals(assignmentInstruction.key)) {
                        CheckParameterUtil.ensureThat(string.contains("=>"), "Separate old from new key by '=>'!");
                        String[] stringArray = string.split("=>", 2);
                        tagCheck.fixCommands.add(FixCommand.fixChangeKey(Tag.removeWhiteSpaces(stringArray[0]), Tag.removeWhiteSpaces(stringArray[1])));
                        continue;
                    }
                    if (string != null && "fixDeleteObject".equals(assignmentInstruction.key)) {
                        CheckParameterUtil.ensureThat("this".equals(string), "fixDeleteObject must be followed by 'this'");
                        tagCheck.deletion = true;
                        continue;
                    }
                    if (string != null && "suggestAlternative".equals(assignmentInstruction.key)) {
                        tagCheck.alternatives.add(string);
                        continue;
                    }
                    if (string != null && "assertMatch".equals(assignmentInstruction.key)) {
                        tagCheck.assertions.put(string, Boolean.TRUE);
                        continue;
                    }
                    if (string != null && "assertNoMatch".equals(assignmentInstruction.key)) {
                        tagCheck.assertions.put(string, Boolean.FALSE);
                        continue;
                    }
                    if (string != null && "group".equals(assignmentInstruction.key)) {
                        tagCheck.group = string;
                        continue;
                    }
                    throw new IllegalDataException("Cannot add instruction " + assignmentInstruction.key + ": " + assignmentInstruction.val + '!');
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalDataException(illegalArgumentException);
                }
            }
            if (tagCheck.errors.isEmpty() && tagCheck.setClassExpressions.isEmpty()) {
                throw new IllegalDataException("No " + POSSIBLE_THROWS + " given! You should specify a validation error message for " + groupedMapCSSRule.selectors);
            }
            if (tagCheck.errors.size() > 1) {
                throw new IllegalDataException("More than one " + POSSIBLE_THROWS + " given! You should specify a single validation error message for " + groupedMapCSSRule.selectors);
            }
            return tagCheck;
        }

        static ParseResult readMapCSS(Reader reader) throws ParseException {
            CheckParameterUtil.ensureParameterNotNull(reader, "css");
            MapCSSStyleSource mapCSSStyleSource = new MapCSSStyleSource("");
            MapCSSParser mapCSSParser = new MapCSSParser(reader, MapCSSParser.LexicalState.PREPROCESSOR);
            StringReader stringReader = new StringReader(mapCSSParser.pp_root(mapCSSStyleSource));
            MapCSSParser mapCSSParser2 = new MapCSSParser(stringReader, MapCSSParser.LexicalState.DEFAULT);
            mapCSSParser2.sheet(mapCSSStyleSource);
            TagCheck.removeMetaRules(mapCSSStyleSource);
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (MapCSSRule object : mapCSSStyleSource.rules) {
                if (!linkedHashMap.containsKey(object.declaration)) {
                    ArrayList<Selector> arrayList = new ArrayList<Selector>();
                    arrayList.add(object.selector);
                    linkedHashMap.put(object.declaration, arrayList);
                    continue;
                }
                ((List)linkedHashMap.get(object.declaration)).add(object.selector);
            }
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                try {
                    arrayList.add(TagCheck.ofMapCSSRule(new GroupedMapCSSRule((List)entry.getValue(), (MapCSSRule.Declaration)entry.getKey())));
                }
                catch (IllegalDataException illegalDataException) {
                    Main.error("Cannot add MapCss rule: " + illegalDataException.getMessage());
                    mapCSSStyleSource.logError(illegalDataException);
                }
            }
            return new ParseResult(arrayList, mapCSSStyleSource.getErrors());
        }

        private static void removeMetaRules(MapCSSStyleSource mapCSSStyleSource) {
            Iterator<MapCSSRule> iterator = mapCSSStyleSource.rules.iterator();
            while (iterator.hasNext()) {
                MapCSSRule mapCSSRule = iterator.next();
                if (!(mapCSSRule.selector instanceof Selector.GeneralSelector)) continue;
                Selector.GeneralSelector generalSelector = (Selector.GeneralSelector)mapCSSRule.selector;
                if (!"meta".equals(generalSelector.base)) continue;
                iterator.remove();
            }
        }

        @Override
        public boolean test(OsmPrimitive osmPrimitive) {
            return this.whichSelectorMatchesPrimitive(osmPrimitive) != null;
        }

        Selector whichSelectorMatchesPrimitive(OsmPrimitive osmPrimitive) {
            return this.whichSelectorMatchesEnvironment(new Environment(osmPrimitive));
        }

        Selector whichSelectorMatchesEnvironment(Environment environment) {
            for (Selector selector : this.rule.selectors) {
                environment.clearSelectorMatchingInformation();
                if (!selector.matches(environment)) continue;
                return selector;
            }
            return null;
        }

        static String determineArgument(Selector.GeneralSelector generalSelector, int n, String string, OsmPrimitive osmPrimitive) {
            try {
                Tag tag;
                Condition condition = generalSelector.getConditions().get(n);
                Tag tag2 = tag = condition instanceof Condition.ToTagConvertable ? ((Condition.ToTagConvertable)((Object)condition)).asTag(osmPrimitive) : null;
                if (tag == null) {
                    return null;
                }
                if ("key".equals(string)) {
                    return tag.getKey();
                }
                if ("value".equals(string)) {
                    return tag.getValue();
                }
                if ("tag".equals(string)) {
                    return tag.toString();
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Main.debug(indexOutOfBoundsException);
            }
            return null;
        }

        static String insertArguments(Selector selector, String string, OsmPrimitive osmPrimitive) {
            if (string != null && selector instanceof Selector.ChildOrParentSelector) {
                return TagCheck.insertArguments(((Selector.ChildOrParentSelector)selector).right, string, osmPrimitive);
            }
            if (string == null || !(selector instanceof Selector.GeneralSelector)) {
                return string;
            }
            Matcher matcher = Pattern.compile("\\{(\\d+)\\.(key|value|tag)\\}").matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string2 = TagCheck.determineArgument((Selector.GeneralSelector)selector, Integer.parseInt(matcher.group(1)), matcher.group(2), osmPrimitive);
                try {
                    matcher.appendReplacement(stringBuffer, String.valueOf(string2).replace("^(", "").replace(")$", ""));
                }
                catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
                    Main.error((Throwable)runtimeException, I18n.tr("Unable to replace argument {0} in {1}: {2}", string2, stringBuffer, runtimeException.getMessage()));
                }
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }

        Command fixPrimitive(OsmPrimitive osmPrimitive) {
            if (this.fixCommands.isEmpty() && !this.deletion) {
                return null;
            }
            Selector selector = this.whichSelectorMatchesPrimitive(osmPrimitive);
            LinkedList<Command> linkedList = new LinkedList<Command>();
            for (FixCommand fixCommand : this.fixCommands) {
                linkedList.add(fixCommand.createCommand(osmPrimitive, selector));
            }
            if (this.deletion && !osmPrimitive.isDeleted()) {
                linkedList.add(new DeleteCommand(osmPrimitive));
            }
            return new SequenceCommand(I18n.tr("Fix of {0}", this.getDescriptionForMatchingSelector(osmPrimitive, selector)), linkedList);
        }

        String getMessage(OsmPrimitive osmPrimitive) {
            if (this.errors.isEmpty()) {
                return this.rule.declaration.toString();
            }
            Object object = this.errors.keySet().iterator().next().val;
            return String.valueOf(object instanceof Expression ? ((Expression)object).evaluate(new Environment(osmPrimitive)) : object);
        }

        String getDescription(OsmPrimitive osmPrimitive) {
            if (this.alternatives.isEmpty()) {
                return this.getMessage(osmPrimitive);
            }
            return I18n.tr("{0}, use {1} instead", this.getMessage(osmPrimitive), Utils.join(I18n.tr(" or ", new Object[0]), this.alternatives));
        }

        String getDescriptionForMatchingSelector(OsmPrimitive osmPrimitive, Selector selector) {
            return TagCheck.insertArguments(selector, this.getDescription(osmPrimitive), osmPrimitive);
        }

        Severity getSeverity() {
            return this.errors.isEmpty() ? null : this.errors.values().iterator().next();
        }

        public String toString() {
            return this.getDescription(null);
        }

        TestError getErrorForPrimitive(OsmPrimitive osmPrimitive) {
            Environment environment = new Environment(osmPrimitive);
            return this.getErrorForPrimitive(osmPrimitive, this.whichSelectorMatchesEnvironment(environment), environment, null);
        }

        TestError getErrorForPrimitive(OsmPrimitive osmPrimitive, Selector selector, Environment environment, Test test) {
            if (selector != null && !this.errors.isEmpty()) {
                Command command = this.fixPrimitive(osmPrimitive);
                String string = this.getDescriptionForMatchingSelector(osmPrimitive, selector);
                String string2 = this.group == null ? string : this.group;
                String string3 = this.group == null ? null : string;
                List<OsmPrimitive> list = environment.child != null ? Arrays.asList(osmPrimitive, environment.child) : Collections.singletonList(osmPrimitive);
                TestError.Builder builder = TestError.builder(test, this.getSeverity(), 3000).messageWithManuallyTranslatedDescription(string2, string3, selector.toString()).primitives(list);
                if (command != null) {
                    return builder.fix(() -> command).build();
                }
                return builder.build();
            }
            return null;
        }

        public Set<TagCheck> getTagCheckDependencies(Collection<TagCheck> collection) {
            HashSet<TagCheck> hashSet = new HashSet<TagCheck>();
            Set<String> set = this.getClassesIds();
            if (collection != null && !set.isEmpty()) {
                block0: for (TagCheck tagCheck : collection) {
                    if (this.equals(tagCheck)) continue;
                    for (String string : tagCheck.setClassExpressions) {
                        if (!set.contains(string)) continue;
                        hashSet.add(tagCheck);
                        continue block0;
                    }
                }
            }
            return hashSet;
        }

        public Set<String> getClassesIds() {
            HashSet<String> hashSet = new HashSet<String>();
            for (Selector selector : this.rule.selectors) {
                if (!(selector instanceof Selector.AbstractSelector)) continue;
                for (Condition condition : ((Selector.AbstractSelector)selector).getConditions()) {
                    if (!(condition instanceof ConditionFactory.ClassCondition)) continue;
                    hashSet.add(((ConditionFactory.ClassCondition)condition).id);
                }
            }
            return hashSet;
        }
    }

    public static class ParseResult {
        public final List<TagCheck> parseChecks;
        public final Collection<Throwable> parseErrors;

        public ParseResult(List<TagCheck> list, Collection<Throwable> collection) {
            this.parseChecks = list;
            this.parseErrors = collection;
        }
    }

    @FunctionalInterface
    static interface FixCommand {
        public Command createCommand(OsmPrimitive var1, Selector var2);

        public static void checkObject(Object object) {
            CheckParameterUtil.ensureThat(object instanceof Expression || object instanceof String, "instance of Exception or String expected, but got " + object);
        }

        public static String evaluateObject(Object object, OsmPrimitive osmPrimitive, Selector selector) {
            String string;
            if (object instanceof Expression) {
                string = (String)((Expression)object).evaluate(new Environment(osmPrimitive));
            } else if (object instanceof String) {
                string = (String)object;
            } else {
                return null;
            }
            return TagCheck.insertArguments(selector, string, osmPrimitive);
        }

        public static FixCommand fixAdd(final Object object) {
            FixCommand.checkObject(object);
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive osmPrimitive, Selector selector) {
                    Tag tag = Tag.ofString(FixCommand.evaluateObject(object, osmPrimitive, selector));
                    return new ChangePropertyCommand(osmPrimitive, tag.getKey(), tag.getValue());
                }

                public String toString() {
                    return "fixAdd: " + object;
                }
            };
        }

        public static FixCommand fixRemove(final Object object) {
            FixCommand.checkObject(object);
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive osmPrimitive, Selector selector) {
                    String string = FixCommand.evaluateObject(object, osmPrimitive, selector);
                    return new ChangePropertyCommand(osmPrimitive, string, "");
                }

                public String toString() {
                    return "fixRemove: " + object;
                }
            };
        }

        public static FixCommand fixChangeKey(final String string, final String string2) {
            return new FixCommand(){

                @Override
                public Command createCommand(OsmPrimitive osmPrimitive, Selector selector) {
                    return new ChangePropertyKeyCommand(osmPrimitive, TagCheck.insertArguments(selector, string, osmPrimitive), TagCheck.insertArguments(selector, string2, osmPrimitive));
                }

                public String toString() {
                    return "fixChangeKey: " + string + " => " + string2;
                }
            };
        }
    }

    public static class GroupedMapCSSRule {
        public final List<Selector> selectors;
        public final MapCSSRule.Declaration declaration;

        public GroupedMapCSSRule(List<Selector> list, MapCSSRule.Declaration declaration) {
            this.selectors = list;
            this.declaration = declaration;
        }

        public int hashCode() {
            return Objects.hash(this.selectors, this.declaration);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            GroupedMapCSSRule groupedMapCSSRule = (GroupedMapCSSRule)object;
            return Objects.equals(this.selectors, groupedMapCSSRule.selectors) && Objects.equals(this.declaration, groupedMapCSSRule.declaration);
        }

        public String toString() {
            return "GroupedMapCSSRule [selectors=" + this.selectors + ", declaration=" + this.declaration + ']';
        }
    }
}

