/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.conflict.pair.ConflictResolver;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictResolutionDialog
extends ExtendedDialog
implements PropertyChangeListener {
    private final ConflictResolver resolver = new ConflictResolver();
    private final JLabel titleLabel = new JLabel("", null, 0);
    private final ApplyResolutionAction applyResolutionAction = new ApplyResolutionAction();
    private boolean isRegistered;

    public ConflictResolutionDialog(Component component) {
        super(component, I18n.tr("Resolve conflicts", new Object[0]), null, null, null);
        this.setDefaultButton(1);
        this.setCancelButton(2);
        this.build();
        this.pack();
        if (this.getInsets().top > 0) {
            this.titleLabel.setVisible(false);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unregisterListeners();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.registerListeners();
    }

    private synchronized void registerListeners() {
        if (!this.isRegistered) {
            this.resolver.addPropertyChangeListener(this.applyResolutionAction);
            this.resolver.registerListeners();
            this.isRegistered = true;
        }
    }

    private synchronized void unregisterListeners() {
        if (this.isRegistered) {
            this.resolver.removePropertyChangeListener(this.applyResolutionAction);
            this.resolver.unregisterListeners();
            this.isRegistered = false;
        }
    }

    protected void build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.titleLabel, "North");
        this.updateTitle();
        this.resolver.setName("panel.conflictresolver");
        jPanel.add((Component)this.resolver, "Center");
        this.resolver.addPropertyChangeListener(this);
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("Dialog/Conflict"));
        this.setContent(jPanel, false);
    }

    @Override
    protected Action createButtonAction(int n) {
        switch (n) {
            case 0: {
                return this.applyResolutionAction;
            }
            case 1: {
                return new CancelAction();
            }
            case 2: {
                return new HelpAction();
            }
        }
        return super.createButtonAction(n);
    }

    public ConflictResolver getConflictResolver() {
        return this.resolver;
    }

    protected void updateTitle() {
        this.updateTitle(null);
    }

    protected void updateTitle(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            this.setTitle(I18n.tr("Resolve conflicts", new Object[0]));
        } else {
            this.setTitle(I18n.tr("Resolve conflicts for ''{0}''", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
        }
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        if (this.titleLabel != null) {
            this.titleLabel.setText(string);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ConflictResolver.MY_PRIMITIVE_PROP)) {
            this.updateTitle((OsmPrimitive)propertyChangeEvent.getNewValue());
        }
    }

    class ApplyResolutionAction
    extends AbstractAction
    implements PropertyChangeListener {
        ApplyResolutionAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts and close the dialog", new Object[0]));
            this.putValue("Name", I18n.tr("Apply Resolution", new Object[0]));
            new ImageProvider("dialogs", "conflict").getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(ConflictResolutionDialog.this.resolver.isResolvedCompletely());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!ConflictResolutionDialog.this.resolver.isResolvedCompletely()) {
                Object[] objectArray = new Object[]{I18n.tr("Close anyway", new Object[0]), I18n.tr("Continue resolving", new Object[0])};
                int n = JOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>You did not finish to merge the differences in this conflict.<br>Conflict resolutions will not be applied unless all differences<br>are resolved.<br>Click <strong>{0}</strong> to close anyway.<strong> Already<br>resolved differences will not be applied.</strong><br>Click <strong>{1}</strong> to return to resolving conflicts.</html>", objectArray[0].toString(), objectArray[1].toString()), I18n.tr("Conflict not resolved completely", new Object[0]), 0, 2, null, objectArray, objectArray[1]);
                switch (n) {
                    case 0: {
                        ConflictResolutionDialog.this.buttonAction(1, actionEvent);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            Main.main.undoRedo.add(ConflictResolutionDialog.this.resolver.buildResolveCommand());
            ConflictResolutionDialog.this.buttonAction(1, actionEvent);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(ConflictResolver.RESOLVED_COMPLETELY_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    static class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information", new Object[0]));
            this.putValue("Name", I18n.tr("Help", new Object[0]));
            new ImageProvider("help").getResource().attachImageIcon(this);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.setUrlForHelpTopic(HelpUtil.ht("/Dialog/Conflict"));
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution and close the dialog", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConflictResolutionDialog.this.buttonAction(2, actionEvent);
        }
    }
}

