/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;

public class UidInputFieldValidator
extends AbstractTextComponentValidator {
    public UidInputFieldValidator(JTextComponent jTextComponent) {
        super(jTextComponent);
    }

    public static UidInputFieldValidator decorate(JTextComponent jTextComponent) {
        return new UidInputFieldValidator(jTextComponent);
    }

    @Override
    public boolean isValid() {
        return this.getUid() > 0;
    }

    @Override
    public void validate() {
        String string = this.getComponent().getText();
        if (string == null || string.trim().isEmpty()) {
            this.feedbackInvalid("");
            return;
        }
        try {
            int n = Integer.parseInt(string);
            if (n <= 0) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid user ID. Please enter an integer value > 0", new Object[0]));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.feedbackInvalid(I18n.tr("The current value is not a valid user ID. Please enter an integer value > 0", new Object[0]));
            return;
        }
        this.feedbackValid(I18n.tr("Please enter an integer value > 0", new Object[0]));
    }

    public int getUid() {
        String string = this.getComponent().getText();
        if (string == null || string.trim().isEmpty()) {
            return 0;
        }
        try {
            int n = Integer.parseInt(string.trim());
            if (n > 0) {
                return n;
            }
            return 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

