/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.dialogs.changeset.query.RestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.UidInputFieldValidator;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.UserNameValidator;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class UserRestrictionPanel
extends JPanel
implements RestrictionPanel {
    private static final String PREF_ROOT = "changeset-query.advanced.user-restrictions";
    private static final String PREF_QUERY_TYPE = "changeset-query.advanced.user-restrictions.query-type";
    private final ButtonGroup bgUserRestrictions = new ButtonGroup();
    private final JRadioButton rbRestrictToMyself = new JRadioButton();
    private final JRadioButton rbRestrictToUid = new JRadioButton();
    private final JRadioButton rbRestrictToUserName = new JRadioButton();
    private final JosmTextField tfUid = new JosmTextField(10);
    private transient UidInputFieldValidator valUid;
    private final JosmTextField tfUserName = new JosmTextField(10);
    private transient UserNameValidator valUserName;
    private final JMultilineLabel lblRestrictedToMyself = new JMultilineLabel(I18n.tr("Only changesets owned by myself", new Object[0]));

    public UserRestrictionPanel() {
        this.build();
    }

    protected JPanel buildUidInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("User ID:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfUid, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUid);
        this.valUid = UidInputFieldValidator.decorate(this.tfUid);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildUserNameInputPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel.add((Component)new JLabel(I18n.tr("User name:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.tfUserName, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfUserName);
        this.valUserName = new UserNameValidator(this.tfUserName);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        UserRestrictionChangedHandler userRestrictionChangedHandler = new UserRestrictionChangedHandler();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rbRestrictToMyself, gridBagConstraints);
        this.rbRestrictToMyself.addItemListener(userRestrictionChangedHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lblRestrictedToMyself, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rbRestrictToUid, gridBagConstraints);
        this.rbRestrictToUid.addItemListener(userRestrictionChangedHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Only changesets owned by the user with the following user ID", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.buildUidInputPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.rbRestrictToUserName, gridBagConstraints);
        this.rbRestrictToUserName.addItemListener(userRestrictionChangedHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JMultilineLabel(I18n.tr("Only changesets owned by the user with the following user name", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.buildUserNameInputPanel(), gridBagConstraints);
        this.bgUserRestrictions.add(this.rbRestrictToMyself);
        this.bgUserRestrictions.add(this.rbRestrictToUid);
        this.bgUserRestrictions.add(this.rbRestrictToUserName);
    }

    public void startUserInput() {
        if (JosmUserIdentityManager.getInstance().isAnonymous()) {
            this.lblRestrictedToMyself.setText(I18n.tr("Only changesets owned by myself (disabled. JOSM is currently run by an anonymous user)", new Object[0]));
            this.rbRestrictToMyself.setEnabled(false);
            if (this.rbRestrictToMyself.isSelected()) {
                this.rbRestrictToUid.setSelected(true);
            }
        } else {
            this.lblRestrictedToMyself.setText(I18n.tr("Only changesets owned by myself", new Object[0]));
            this.rbRestrictToMyself.setEnabled(true);
            this.rbRestrictToMyself.setSelected(true);
        }
        this.restoreFromSettings();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fillInQuery(ChangesetQuery changesetQuery) {
        CheckParameterUtil.ensureParameterNotNull(changesetQuery, "query");
        if (this.rbRestrictToMyself.isSelected()) {
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            if (josmUserIdentityManager.isPartiallyIdentified()) {
                changesetQuery.forUser(josmUserIdentityManager.getUserName());
                return;
            } else {
                if (!josmUserIdentityManager.isFullyIdentified()) throw new IllegalStateException(I18n.tr("Cannot restrict changeset query to the current user because the current user is anonymous", new Object[0]));
                changesetQuery.forUser(josmUserIdentityManager.getUserId());
            }
            return;
        } else if (this.rbRestrictToUid.isSelected()) {
            int n = this.valUid.getUid();
            if (n <= 0) throw new IllegalStateException(I18n.tr("Current value ''{0}'' for user ID is not valid", this.tfUid.getText()));
            changesetQuery.forUser(n);
            return;
        } else {
            if (!this.rbRestrictToUserName.isSelected()) return;
            if (!this.valUserName.isValid()) {
                throw new IllegalStateException(I18n.tr("Cannot restrict the changeset query to the user name ''{0}''", this.tfUserName.getText()));
            }
            changesetQuery.forUser(this.tfUserName.getText());
        }
    }

    @Override
    public boolean isValidChangesetQuery() {
        if (this.rbRestrictToUid.isSelected()) {
            return this.valUid.isValid();
        }
        if (this.rbRestrictToUserName.isSelected()) {
            return this.valUserName.isValid();
        }
        return true;
    }

    protected void alertInvalidUid() {
        HelpAwareOptionPane.showOptionDialog(this, I18n.tr("Please enter a valid user ID", new Object[0]), I18n.tr("Invalid user ID", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidUserId"));
    }

    protected void alertInvalidUserName() {
        HelpAwareOptionPane.showOptionDialog(this, I18n.tr("Please enter a non-empty user name", new Object[0]), I18n.tr("Invalid user name", new Object[0]), 0, HelpUtil.ht("/Dialog/ChangesetQueryDialog#InvalidUserName"));
    }

    @Override
    public void displayMessageIfInvalid() {
        if (this.rbRestrictToUid.isSelected()) {
            if (!this.valUid.isValid()) {
                this.alertInvalidUid();
            }
        } else if (this.rbRestrictToUserName.isSelected() && !this.valUserName.isValid()) {
            this.alertInvalidUserName();
        }
    }

    public void rememberSettings() {
        if (this.rbRestrictToMyself.isSelected()) {
            Main.pref.put(PREF_QUERY_TYPE, "mine");
        } else if (this.rbRestrictToUid.isSelected()) {
            Main.pref.put(PREF_QUERY_TYPE, "uid");
        } else if (this.rbRestrictToUserName.isSelected()) {
            Main.pref.put(PREF_QUERY_TYPE, "username");
        }
        Main.pref.put("changeset-query.advanced.user-restrictions.uid", this.tfUid.getText());
        Main.pref.put("changeset-query.advanced.user-restrictions.username", this.tfUserName.getText());
    }

    public void restoreFromSettings() {
        String string = Main.pref.get(PREF_QUERY_TYPE, "mine");
        if ("mine".equals(string)) {
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            if (josmUserIdentityManager.isAnonymous()) {
                this.rbRestrictToUid.setSelected(true);
            } else {
                this.rbRestrictToMyself.setSelected(true);
            }
        } else if ("uid".equals(string)) {
            this.rbRestrictToUid.setSelected(true);
        } else if ("username".equals(string)) {
            this.rbRestrictToUserName.setSelected(true);
        }
        this.tfUid.setText(Main.pref.get("changeset-query.advanced.user-restrictions.uid", ""));
        if (!this.valUid.isValid()) {
            this.tfUid.setText("");
        }
        this.tfUserName.setText(Main.pref.get("changeset-query.advanced.user-restrictions.username", ""));
    }

    class UserRestrictionChangedHandler
    implements ItemListener {
        UserRestrictionChangedHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            UserRestrictionPanel.this.tfUid.setEnabled(UserRestrictionPanel.this.rbRestrictToUid.isSelected());
            UserRestrictionPanel.this.tfUserName.setEnabled(UserRestrictionPanel.this.rbRestrictToUserName.isSelected());
            if (UserRestrictionPanel.this.rbRestrictToUid.isSelected()) {
                UserRestrictionPanel.this.tfUid.requestFocusInWindow();
            } else if (UserRestrictionPanel.this.rbRestrictToUserName.isSelected()) {
                UserRestrictionPanel.this.tfUserName.requestFocusInWindow();
            }
        }
    }
}

