/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Graphics2D;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.PaintVisitor;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.MultiMap;

public class ValidatorLayer
extends Layer
implements LayerManager.LayerChangeListener {
    private final Runnable invalidator = this::invalidate;

    public ValidatorLayer() {
        super(I18n.tr("Validation errors", new Object[0]));
        Main.getLayerManager().addLayerChangeListener(this);
        Main.map.validatorDialog.tree.addInvalidationListener(this.invalidator);
    }

    @Override
    public Icon getIcon() {
        return ImageProvider.get("layer", "validator_small");
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        DefaultMutableTreeNode defaultMutableTreeNode = Main.map.validatorDialog.tree.getRoot();
        if (defaultMutableTreeNode == null || defaultMutableTreeNode.getChildCount() == 0) {
            return;
        }
        PaintVisitor paintVisitor = new PaintVisitor(graphics2D, mapView);
        for (DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getLastChild(); defaultMutableTreeNode2 != null; defaultMutableTreeNode2 = defaultMutableTreeNode2.getPreviousSibling()) {
            Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                Object object = ((DefaultMutableTreeNode)enumeration.nextElement()).getUserObject();
                if (!(object instanceof TestError)) continue;
                paintVisitor.visit((TestError)object);
            }
        }
        paintVisitor.clearPaintedObjects();
    }

    @Override
    public String getToolTipText() {
        MultiMap<Severity, TestError> multiMap = new MultiMap<Severity, TestError>();
        List<TestError> list = Main.map.validatorDialog.tree.getErrors();
        for (TestError severityArray : list) {
            multiMap.put(severityArray.getSeverity(), severityArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Severity severity : Severity.values()) {
            if (!multiMap.containsKey(severity)) continue;
            stringBuilder.append(I18n.tr(severity.toString(), new Object[0])).append(": ").append(multiMap.get(severity).size()).append("<br>");
        }
        if (stringBuilder.length() == 0) {
            return "<html>" + I18n.tr("No validation errors", new Object[0]) + "</html>";
        }
        return "<html>" + I18n.tr("Validation errors", new Object[0]) + ":<br>" + stringBuilder + "</html>";
    }

    @Override
    public void mergeFrom(Layer layer) {
    }

    @Override
    public boolean isMergable(Layer layer) {
        return false;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    @Override
    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new RenameLayerAction(null, this), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent layerOrderChangeEvent) {
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent layerAddEvent) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent layerRemoveEvent) {
        if (layerRemoveEvent.getRemovedLayer() instanceof OsmDataLayer && layerRemoveEvent.getSource().getLayersOfType(OsmDataLayer.class).size() <= 1) {
            layerRemoveEvent.scheduleRemoval(Collections.singleton(this));
        } else if (layerRemoveEvent.getRemovedLayer() == this) {
            OsmValidator.resetErrorLayer();
        }
    }

    @Override
    public LayerPositionStrategy getDefaultLayerPosition() {
        return LayerPositionStrategy.IN_FRONT;
    }

    @Override
    public synchronized void destroy() {
        Main.map.validatorDialog.tree.removeInvalidationListener(this.invalidator);
        Main.getLayerManager().removeLayerChangeListener(this);
        super.destroy();
    }
}

